/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.view.View;

public final class AntiShakeUtils {
    private static final long DEFAULT_DURATION = 200L;
    private static final int TAG_KEY = 0x7EFFFFFF;

    private AntiShakeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isValid(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 1, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        return AntiShakeUtils.isValid(view, 200L);
    }

    public static boolean isValid(@NonNull View view, @IntRange(from=0L) long duration) {
        if (view == null) {
            throw new NullPointerException("Argument 'view' of type View (#0 out of 2, zero-based) is marked by @android.support.annotation.NonNull but got null for it");
        }
        long curTime = System.currentTimeMillis();
        Object tag = view.getTag(0x7EFFFFFF);
        if (!(tag instanceof Long)) {
            view.setTag(0x7EFFFFFF, (Object)curTime);
            return true;
        }
        long preTime = (Long)tag;
        if (curTime - preTime <= duration) {
            return false;
        }
        view.setTag(0x7EFFFFFF, (Object)curTime);
        return true;
    }
}

