/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Process;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresApi;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import com.blankj.utilcode.util.ThrowableUtils;
import com.blankj.utilcode.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class LogUtils {
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int A = 7;
    private static final char[] T = new char[]{'V', 'D', 'I', 'W', 'E', 'A'};
    private static final int FILE = 16;
    private static final int JSON = 32;
    private static final int XML = 48;
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String TOP_CORNER = "\u250c";
    private static final String MIDDLE_CORNER = "\u251c";
    private static final String LEFT_BORDER = "\u2502 ";
    private static final String BOTTOM_CORNER = "\u2514";
    private static final String SIDE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final int MAX_LEN = 3000;
    private static final String NOTHING = "log nothing";
    private static final String NULL = "null";
    private static final String ARGS = "args";
    private static final String PLACEHOLDER = " ";
    private static final Config CONFIG = new Config();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final ThreadLocal<SimpleDateFormat> SDF_THREAD_LOCAL = new ThreadLocal();
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private static final SimpleArrayMap<Class, IFormatter> I_FORMATTER_MAP = new SimpleArrayMap();

    private LogUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Config getConfig() {
        return CONFIG;
    }

    public static void v(Object ... contents) {
        LogUtils.log(2, CONFIG.getGlobalTag(), contents);
    }

    public static void vTag(String tag, Object ... contents) {
        LogUtils.log(2, tag, contents);
    }

    public static void d(Object ... contents) {
        LogUtils.log(3, CONFIG.getGlobalTag(), contents);
    }

    public static void dTag(String tag, Object ... contents) {
        LogUtils.log(3, tag, contents);
    }

    public static void i(Object ... contents) {
        LogUtils.log(4, CONFIG.getGlobalTag(), contents);
    }

    public static void iTag(String tag, Object ... contents) {
        LogUtils.log(4, tag, contents);
    }

    public static void w(Object ... contents) {
        LogUtils.log(5, CONFIG.getGlobalTag(), contents);
    }

    public static void wTag(String tag, Object ... contents) {
        LogUtils.log(5, tag, contents);
    }

    public static void e(Object ... contents) {
        LogUtils.log(6, CONFIG.getGlobalTag(), contents);
    }

    public static void eTag(String tag, Object ... contents) {
        LogUtils.log(6, tag, contents);
    }

    public static void a(Object ... contents) {
        LogUtils.log(7, CONFIG.getGlobalTag(), contents);
    }

    public static void aTag(String tag, Object ... contents) {
        LogUtils.log(7, tag, contents);
    }

    public static void file(Object content) {
        LogUtils.log(19, CONFIG.getGlobalTag(), content);
    }

    public static void file(int type, Object content) {
        LogUtils.log(0x10 | type, CONFIG.getGlobalTag(), content);
    }

    public static void file(String tag, Object content) {
        LogUtils.log(19, tag, content);
    }

    public static void file(int type, String tag, Object content) {
        LogUtils.log(0x10 | type, tag, content);
    }

    public static void json(Object content) {
        LogUtils.log(35, CONFIG.getGlobalTag(), content);
    }

    public static void json(int type, Object content) {
        LogUtils.log(0x20 | type, CONFIG.getGlobalTag(), content);
    }

    public static void json(String tag, Object content) {
        LogUtils.log(35, tag, content);
    }

    public static void json(int type, String tag, Object content) {
        LogUtils.log(0x20 | type, tag, content);
    }

    public static void xml(String content) {
        LogUtils.log(51, CONFIG.getGlobalTag(), content);
    }

    public static void xml(int type, String content) {
        LogUtils.log(0x30 | type, CONFIG.getGlobalTag(), content);
    }

    public static void xml(String tag, String content) {
        LogUtils.log(51, tag, content);
    }

    public static void xml(int type, String tag, String content) {
        LogUtils.log(0x30 | type, tag, content);
    }

    public static void log(int type, String tag, Object ... contents) {
        if (!CONFIG.isLogSwitch()) {
            return;
        }
        int type_low = type & 0xF;
        int type_high = type & 0xF0;
        if (CONFIG.isLog2ConsoleSwitch() || CONFIG.isLog2FileSwitch() || type_high == 16) {
            if (type_low < CONFIG.mConsoleFilter && type_low < CONFIG.mFileFilter) {
                return;
            }
            TagHead tagHead = LogUtils.processTagAndHead(tag);
            String body = LogUtils.processBody(type_high, contents);
            if (CONFIG.isLog2ConsoleSwitch() && type_high != 16 && type_low >= CONFIG.mConsoleFilter) {
                LogUtils.print2Console(type_low, tagHead.tag, tagHead.consoleHead, body);
            }
            if ((CONFIG.isLog2FileSwitch() || type_high == 16) && type_low >= CONFIG.mFileFilter) {
                LogUtils.print2File(type_low, tagHead.tag, tagHead.fileHead + body);
            }
        }
    }

    private static TagHead processTagAndHead(String tag) {
        if (!CONFIG.mTagIsSpace && !CONFIG.isLogHeadSwitch()) {
            tag = CONFIG.getGlobalTag();
        } else {
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            int stackIndex = 3 + CONFIG.getStackOffset();
            if (stackIndex >= stackTrace.length) {
                StackTraceElement targetElement = stackTrace[3];
                String fileName = LogUtils.getFileName(targetElement);
                if (CONFIG.mTagIsSpace && LogUtils.isSpace(tag)) {
                    int index = fileName.indexOf(46);
                    tag = index == -1 ? fileName : fileName.substring(0, index);
                }
                return new TagHead(tag, null, ": ");
            }
            StackTraceElement targetElement = stackTrace[stackIndex];
            String fileName = LogUtils.getFileName(targetElement);
            if (CONFIG.mTagIsSpace && LogUtils.isSpace(tag)) {
                int index = fileName.indexOf(46);
                String string = tag = index == -1 ? fileName : fileName.substring(0, index);
            }
            if (CONFIG.isLogHeadSwitch()) {
                String tName = Thread.currentThread().getName();
                String head = new Formatter().format("%s, %s.%s(%s:%d)", tName, targetElement.getClassName(), targetElement.getMethodName(), fileName, targetElement.getLineNumber()).toString();
                String fileHead = " [" + head + "]: ";
                if (CONFIG.getStackDeep() <= 1) {
                    return new TagHead(tag, new String[]{head}, fileHead);
                }
                String[] consoleHead = new String[Math.min(CONFIG.getStackDeep(), stackTrace.length - stackIndex)];
                consoleHead[0] = head;
                int spaceLen = tName.length() + 2;
                String space = new Formatter().format("%" + spaceLen + "s", "").toString();
                int len = consoleHead.length;
                for (int i = 1; i < len; ++i) {
                    targetElement = stackTrace[i + stackIndex];
                    consoleHead[i] = new Formatter().format("%s%s.%s(%s:%d)", space, targetElement.getClassName(), targetElement.getMethodName(), LogUtils.getFileName(targetElement), targetElement.getLineNumber()).toString();
                }
                return new TagHead(tag, consoleHead, fileHead);
            }
        }
        return new TagHead(tag, null, ": ");
    }

    private static String getFileName(StackTraceElement targetElement) {
        int index;
        String fileName = targetElement.getFileName();
        if (fileName != null) {
            return fileName;
        }
        String className = targetElement.getClassName();
        String[] classNameInfo = className.split("\\.");
        if (classNameInfo.length > 0) {
            className = classNameInfo[classNameInfo.length - 1];
        }
        if ((index = className.indexOf(36)) != -1) {
            className = className.substring(0, index);
        }
        return className + ".java";
    }

    private static String processBody(int type, Object ... contents) {
        String body = NULL;
        if (contents != null) {
            if (contents.length == 1) {
                body = LogUtils.formatObject(type, contents[0]);
            } else {
                StringBuilder sb = new StringBuilder();
                int len = contents.length;
                for (int i = 0; i < len; ++i) {
                    Object content = contents[i];
                    sb.append(ARGS).append("[").append(i).append("]").append(" = ").append(LogUtils.formatObject(content)).append(LINE_SEP);
                }
                body = sb.toString();
            }
        }
        return body.length() == 0 ? NOTHING : body;
    }

    private static String formatObject(int type, Object object) {
        if (object == null) {
            return NULL;
        }
        if (type == 32) {
            return LogFormatter.object2Json(object);
        }
        if (type == 48) {
            return LogFormatter.formatXml(object.toString());
        }
        return LogUtils.formatObject(object);
    }

    private static String formatObject(Object object) {
        IFormatter iFormatter;
        if (object == null) {
            return NULL;
        }
        if (!I_FORMATTER_MAP.isEmpty() && (iFormatter = (IFormatter)I_FORMATTER_MAP.get((Object)LogUtils.getClassFromObject(object))) != null) {
            return iFormatter.format(object);
        }
        return LogFormatter.object2String(object);
    }

    private static void print2Console(int type, String tag, String[] head, String msg) {
        if (CONFIG.isSingleTagSwitch()) {
            LogUtils.printSingleTagMsg(type, tag, LogUtils.processSingleTagMsg(type, tag, head, msg));
        } else {
            LogUtils.printBorder(type, tag, true);
            LogUtils.printHead(type, tag, head);
            LogUtils.printMsg(type, tag, msg);
            LogUtils.printBorder(type, tag, false);
        }
    }

    private static void printBorder(int type, String tag, boolean isTop) {
        if (CONFIG.isLogBorderSwitch()) {
            Log.println((int)type, (String)tag, (String)(isTop ? TOP_BORDER : BOTTOM_BORDER));
        }
    }

    private static void printHead(int type, String tag, String[] head) {
        if (head != null) {
            for (String aHead : head) {
                Log.println((int)type, (String)tag, (String)(CONFIG.isLogBorderSwitch() ? LEFT_BORDER + aHead : aHead));
            }
            if (CONFIG.isLogBorderSwitch()) {
                Log.println((int)type, (String)tag, (String)MIDDLE_BORDER);
            }
        }
    }

    private static void printMsg(int type, String tag, String msg) {
        int len = msg.length();
        int countOfSub = len / 3000;
        if (countOfSub > 0) {
            int index = 0;
            for (int i = 0; i < countOfSub; ++i) {
                LogUtils.printSubMsg(type, tag, msg.substring(index, index + 3000));
                index += 3000;
            }
            if (index != len) {
                LogUtils.printSubMsg(type, tag, msg.substring(index, len));
            }
        } else {
            LogUtils.printSubMsg(type, tag, msg);
        }
    }

    private static void printSubMsg(int type, String tag, String msg) {
        String[] lines;
        if (!CONFIG.isLogBorderSwitch()) {
            Log.println((int)type, (String)tag, (String)msg);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = msg.split(LINE_SEP)) {
            Log.println((int)type, (String)tag, (String)(LEFT_BORDER + line));
        }
    }

    private static String processSingleTagMsg(int type, String tag, String[] head, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(PLACEHOLDER).append(LINE_SEP);
        if (CONFIG.isLogBorderSwitch()) {
            sb.append(TOP_BORDER).append(LINE_SEP);
            if (head != null) {
                for (String aHead : head) {
                    sb.append(LEFT_BORDER).append(aHead).append(LINE_SEP);
                }
                sb.append(MIDDLE_BORDER).append(LINE_SEP);
            }
            for (String line : msg.split(LINE_SEP)) {
                sb.append(LEFT_BORDER).append(line).append(LINE_SEP);
            }
            sb.append(BOTTOM_BORDER);
        } else {
            if (head != null) {
                for (String aHead : head) {
                    sb.append(aHead).append(LINE_SEP);
                }
            }
            sb.append(msg);
        }
        return sb.toString();
    }

    private static void printSingleTagMsg(int type, String tag, String msg) {
        int len = msg.length();
        int countOfSub = len / 3000;
        if (countOfSub > 0) {
            if (CONFIG.isLogBorderSwitch()) {
                Log.println((int)type, (String)tag, (String)(msg.substring(0, 3000) + LINE_SEP + BOTTOM_BORDER));
                int index = 3000;
                for (int i = 1; i < countOfSub; ++i) {
                    Log.println((int)type, (String)tag, (String)(PLACEHOLDER + LINE_SEP + TOP_BORDER + LINE_SEP + LEFT_BORDER + msg.substring(index, index + 3000) + LINE_SEP + BOTTOM_BORDER));
                    index += 3000;
                }
                if (index != len) {
                    Log.println((int)type, (String)tag, (String)(PLACEHOLDER + LINE_SEP + TOP_BORDER + LINE_SEP + LEFT_BORDER + msg.substring(index, len)));
                }
            } else {
                Log.println((int)type, (String)tag, (String)msg.substring(0, 3000));
                int index = 3000;
                for (int i = 1; i < countOfSub; ++i) {
                    Log.println((int)type, (String)tag, (String)(PLACEHOLDER + LINE_SEP + msg.substring(index, index + 3000)));
                    index += 3000;
                }
                if (index != len) {
                    Log.println((int)type, (String)tag, (String)(PLACEHOLDER + LINE_SEP + msg.substring(index, len)));
                }
            }
        } else {
            Log.println((int)type, (String)tag, (String)msg);
        }
    }

    private static void print2File(int type, String tag, String msg) {
        Date now = new Date(System.currentTimeMillis());
        String format = LogUtils.getSdf().format(now);
        String date = format.substring(0, 10);
        String time = format.substring(11);
        String fullPath = CONFIG.getDir() + CONFIG.getFilePrefix() + "-" + date + "-" + CONFIG.getProcessName() + ".txt";
        if (!LogUtils.createOrExistsFile(fullPath)) {
            Log.e((String)"LogUtils", (String)("create " + fullPath + " failed!"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(time).append(T[type - 2]).append("/").append(tag).append(msg).append(LINE_SEP);
        String content = sb.toString();
        LogUtils.input2File(content, fullPath);
    }

    private static SimpleDateFormat getSdf() {
        SimpleDateFormat simpleDateFormat = SDF_THREAD_LOCAL.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            SDF_THREAD_LOCAL.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!LogUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            LogUtils.deleteDueLogs(filePath);
            boolean isCreate = file.createNewFile();
            if (isCreate) {
                LogUtils.printDeviceInfo(filePath);
            }
            return isCreate;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void deleteDueLogs(String filePath) {
        if (CONFIG.getSaveDays() <= 0) {
            return;
        }
        File file = new File(filePath);
        File parentFile = file.getParentFile();
        File[] files = parentFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("^" + CONFIG.getFilePrefix() + "-[0-9]{4}-[0-9]{2}-[0-9]{2}-" + CONFIG.getProcessName() + ".txt$");
            }
        });
        if (files == null || files.length <= 0) {
            return;
        }
        int length = filePath.length();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            String curDay = filePath.substring(length - 14, length - 4);
            long dueMillis = sdf.parse(curDay).getTime() - (long)CONFIG.getSaveDays() * 86400000L;
            for (final File aFile : files) {
                int l;
                String name = aFile.getName();
                String logDay = name.substring((l = name.length()) - 14, l - 4);
                if (sdf.parse(logDay).getTime() > dueMillis) continue;
                EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        boolean delete = aFile.delete();
                        if (!delete) {
                            Log.e((String)"LogUtils", (String)("delete " + aFile + " failed!"));
                        }
                    }
                });
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static void printDeviceInfo(String filePath) {
        String versionName = "";
        int versionCode = 0;
        try {
            PackageInfo pi = Utils.getApp().getPackageManager().getPackageInfo(Utils.getApp().getPackageName(), 0);
            if (pi != null) {
                versionName = pi.versionName;
                versionCode = pi.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        String time = filePath.substring(filePath.length() - 14, filePath.length() - 4);
        String head = "************* Log Head ****************\nDate of Log        : " + time + "\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + versionName + "\nApp VersionCode    : " + versionCode + "\n************* Log Head ****************\n\n";
        LogUtils.input2File(head, filePath);
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void input2File(final String input, final String filePath) {
        EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(filePath, true));
                    bw.write(input);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)"LogUtils", (String)("log to " + filePath + " failed!"));
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static <T> Class getTypeClassFromParadigm(IFormatter<T> formatter) {
        Type[] genericInterfaces = formatter.getClass().getGenericInterfaces();
        Type type = genericInterfaces.length == 1 ? genericInterfaces[0] : formatter.getClass().getGenericSuperclass();
        type = ((ParameterizedType)type).getActualTypeArguments()[0];
        while (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        String className = type.toString();
        if (className.startsWith("class ")) {
            className = className.substring(6);
        } else if (className.startsWith("interface ")) {
            className = className.substring(10);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class getClassFromObject(Object obj) {
        Class<?> objClass = obj.getClass();
        if (objClass.isAnonymousClass() || objClass.isSynthetic()) {
            String className;
            Type type;
            Type[] genericInterfaces = objClass.getGenericInterfaces();
            if (genericInterfaces.length == 1) {
                type = genericInterfaces[0];
                while (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                className = type.toString();
            } else {
                type = objClass.getGenericSuperclass();
                while (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                className = type.toString();
            }
            if (className.startsWith("class ")) {
                className = className.substring(6);
            } else if (className.startsWith("interface ")) {
                className = className.substring(10);
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return objClass;
    }

    private static class LogFormatter {
        private LogFormatter() {
        }

        static String object2String(Object object) {
            if (object.getClass().isArray()) {
                return LogFormatter.array2String(object);
            }
            if (object instanceof Throwable) {
                return LogFormatter.throwable2String((Throwable)object);
            }
            if (object instanceof Bundle) {
                return LogFormatter.bundle2String((Bundle)object);
            }
            if (object instanceof Intent) {
                return LogFormatter.intent2String((Intent)object);
            }
            return object.toString();
        }

        static String object2Json(Object object) {
            if (object instanceof CharSequence) {
                return LogFormatter.formatJson(object.toString());
            }
            try {
                return GSON.toJson(object);
            }
            catch (Throwable t) {
                return object.toString();
            }
        }

        static String formatXml(String xml) {
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(xml));
                StreamResult xmlOutput = new StreamResult(new StringWriter());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(xmlInput, xmlOutput);
                xml = xmlOutput.getWriter().toString().replaceFirst(">", ">" + LINE_SEP);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return xml;
        }

        private static String throwable2String(Throwable e) {
            return ThrowableUtils.getFullStackTrace(e);
        }

        private static String bundle2String(Bundle bundle) {
            Iterator iterator = bundle.keySet().iterator();
            if (!iterator.hasNext()) {
                return "Bundle {}";
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("Bundle { ");
            while (true) {
                String key = (String)iterator.next();
                Object value = bundle.get(key);
                sb.append(key).append('=');
                if (value instanceof Bundle) {
                    sb.append(value == bundle ? "(this Bundle)" : LogFormatter.bundle2String((Bundle)value));
                } else {
                    sb.append(LogUtils.formatObject(value));
                }
                if (!iterator.hasNext()) {
                    return sb.append(" }").toString();
                }
                sb.append(',').append(' ');
            }
        }

        private static String intent2String(Intent intent) {
            Intent mSelector;
            Bundle mExtras;
            ClipData mClipData;
            Rect mSourceBounds;
            ComponentName mComponent;
            String mPackage;
            int mFlags;
            String mType;
            Uri mData;
            Set mCategories;
            StringBuilder sb = new StringBuilder(128);
            sb.append("Intent { ");
            boolean first = true;
            String mAction = intent.getAction();
            if (mAction != null) {
                sb.append("act=").append(mAction);
                first = false;
            }
            if ((mCategories = intent.getCategories()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("cat=[");
                boolean firstCategory = true;
                for (String c : mCategories) {
                    if (!firstCategory) {
                        sb.append(',');
                    }
                    sb.append(c);
                    firstCategory = false;
                }
                sb.append("]");
            }
            if ((mData = intent.getData()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("dat=").append(mData);
            }
            if ((mType = intent.getType()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("typ=").append(mType);
            }
            if ((mFlags = intent.getFlags()) != 0) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("flg=0x").append(Integer.toHexString(mFlags));
            }
            if ((mPackage = intent.getPackage()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("pkg=").append(mPackage);
            }
            if ((mComponent = intent.getComponent()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("cmp=").append(mComponent.flattenToShortString());
            }
            if ((mSourceBounds = intent.getSourceBounds()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("bnds=").append(mSourceBounds.toShortString());
            }
            if (Build.VERSION.SDK_INT >= 16 && (mClipData = intent.getClipData()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                LogFormatter.clipData2String(mClipData, sb);
            }
            if ((mExtras = intent.getExtras()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("extras={");
                sb.append(LogFormatter.bundle2String(mExtras));
                sb.append('}');
            }
            if (Build.VERSION.SDK_INT >= 15 && (mSelector = intent.getSelector()) != null) {
                if (!first) {
                    sb.append(' ');
                }
                first = false;
                sb.append("sel={");
                sb.append(mSelector == intent ? "(this Intent)" : LogFormatter.intent2String(mSelector));
                sb.append("}");
            }
            sb.append(" }");
            return sb.toString();
        }

        private static String formatJson(String json) {
            try {
                int len = json.length();
                for (int i = 0; i < len; ++i) {
                    char c = json.charAt(i);
                    if (c == '{') {
                        return new JSONObject(json).toString(2);
                    }
                    if (c == '[') {
                        return new JSONArray(json).toString(2);
                    }
                    if (Character.isWhitespace(c)) continue;
                    return json;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return json;
        }

        @RequiresApi(api=16)
        private static void clipData2String(ClipData clipData, StringBuilder sb) {
            ClipData.Item item = clipData.getItemAt(0);
            if (item == null) {
                sb.append("ClipData.Item {}");
                return;
            }
            sb.append("ClipData.Item { ");
            String mHtmlText = item.getHtmlText();
            if (mHtmlText != null) {
                sb.append("H:");
                sb.append(mHtmlText);
                sb.append("}");
                return;
            }
            CharSequence mText = item.getText();
            if (mText != null) {
                sb.append("T:");
                sb.append(mText);
                sb.append("}");
                return;
            }
            Uri uri = item.getUri();
            if (uri != null) {
                sb.append("U:").append(uri);
                sb.append("}");
                return;
            }
            Intent intent = item.getIntent();
            if (intent != null) {
                sb.append("I:");
                sb.append(LogFormatter.intent2String(intent));
                sb.append("}");
                return;
            }
            sb.append("NULL");
            sb.append("}");
        }

        private static String array2String(Object object) {
            if (object instanceof Object[]) {
                return Arrays.deepToString((Object[])object);
            }
            if (object instanceof boolean[]) {
                return Arrays.toString((boolean[])object);
            }
            if (object instanceof byte[]) {
                return Arrays.toString((byte[])object);
            }
            if (object instanceof char[]) {
                return Arrays.toString((char[])object);
            }
            if (object instanceof double[]) {
                return Arrays.toString((double[])object);
            }
            if (object instanceof float[]) {
                return Arrays.toString((float[])object);
            }
            if (object instanceof int[]) {
                return Arrays.toString((int[])object);
            }
            if (object instanceof long[]) {
                return Arrays.toString((long[])object);
            }
            if (object instanceof short[]) {
                return Arrays.toString((short[])object);
            }
            throw new IllegalArgumentException("Array has incompatible type: " + object.getClass());
        }
    }

    private static class TagHead {
        String tag;
        String[] consoleHead;
        String fileHead;

        TagHead(String tag, String[] consoleHead, String fileHead) {
            this.tag = tag;
            this.consoleHead = consoleHead;
            this.fileHead = fileHead;
        }
    }

    public static abstract class IFormatter<T> {
        public abstract String format(T var1);
    }

    public static class Config {
        private String mDefaultDir;
        private String mDir;
        private String mFilePrefix = "util";
        private boolean mLogSwitch = true;
        private boolean mLog2ConsoleSwitch = true;
        private String mGlobalTag = "";
        private boolean mTagIsSpace = true;
        private boolean mLogHeadSwitch = true;
        private boolean mLog2FileSwitch = false;
        private boolean mLogBorderSwitch = true;
        private boolean mSingleTagSwitch = true;
        private int mConsoleFilter = 2;
        private int mFileFilter = 2;
        private int mStackDeep = 1;
        private int mStackOffset = 0;
        private int mSaveDays = -1;
        private String mProcessName = Config.getCurrentProcessName();

        private Config() {
            if (this.mDefaultDir != null) {
                return;
            }
            this.mDefaultDir = "mounted".equals(Environment.getExternalStorageState()) && Utils.getApp().getExternalCacheDir() != null ? Utils.getApp().getExternalCacheDir() + FILE_SEP + "log" + FILE_SEP : Utils.getApp().getCacheDir() + FILE_SEP + "log" + FILE_SEP;
        }

        public Config setLogSwitch(boolean logSwitch) {
            this.mLogSwitch = logSwitch;
            return this;
        }

        public Config setConsoleSwitch(boolean consoleSwitch) {
            this.mLog2ConsoleSwitch = consoleSwitch;
            return this;
        }

        public Config setGlobalTag(String tag) {
            if (LogUtils.isSpace(tag)) {
                this.mGlobalTag = "";
                this.mTagIsSpace = true;
            } else {
                this.mGlobalTag = tag;
                this.mTagIsSpace = false;
            }
            return this;
        }

        public Config setLogHeadSwitch(boolean logHeadSwitch) {
            this.mLogHeadSwitch = logHeadSwitch;
            return this;
        }

        public Config setLog2FileSwitch(boolean log2FileSwitch) {
            this.mLog2FileSwitch = log2FileSwitch;
            return this;
        }

        public Config setDir(String dir) {
            this.mDir = LogUtils.isSpace(dir) ? null : (dir.endsWith(FILE_SEP) ? dir : dir + FILE_SEP);
            return this;
        }

        public Config setDir(File dir) {
            this.mDir = dir == null ? null : dir.getAbsolutePath() + FILE_SEP;
            return this;
        }

        public Config setFilePrefix(String filePrefix) {
            this.mFilePrefix = LogUtils.isSpace(filePrefix) ? "util" : filePrefix;
            return this;
        }

        public Config setBorderSwitch(boolean borderSwitch) {
            this.mLogBorderSwitch = borderSwitch;
            return this;
        }

        public Config setSingleTagSwitch(boolean singleTagSwitch) {
            this.mSingleTagSwitch = singleTagSwitch;
            return this;
        }

        public Config setConsoleFilter(int consoleFilter) {
            this.mConsoleFilter = consoleFilter;
            return this;
        }

        public Config setFileFilter(int fileFilter) {
            this.mFileFilter = fileFilter;
            return this;
        }

        public Config setStackDeep(@IntRange(from=1L) int stackDeep) {
            this.mStackDeep = stackDeep;
            return this;
        }

        public Config setStackOffset(@IntRange(from=0L) int stackOffset) {
            this.mStackOffset = stackOffset;
            return this;
        }

        public Config setSaveDays(@IntRange(from=1L) int saveDays) {
            this.mSaveDays = saveDays;
            return this;
        }

        public final <T> Config addFormatter(IFormatter<T> iFormatter) {
            if (iFormatter != null) {
                I_FORMATTER_MAP.put((Object)LogUtils.getTypeClassFromParadigm(iFormatter), iFormatter);
            }
            return this;
        }

        public String getProcessName() {
            return this.mProcessName;
        }

        public String getDefaultDir() {
            return this.mDefaultDir;
        }

        public String getDir() {
            return this.mDir == null ? this.mDefaultDir : this.mDir;
        }

        public String getFilePrefix() {
            return this.mFilePrefix;
        }

        public boolean isLogSwitch() {
            return this.mLogSwitch;
        }

        public boolean isLog2ConsoleSwitch() {
            return this.mLog2ConsoleSwitch;
        }

        public String getGlobalTag() {
            if (LogUtils.isSpace(this.mGlobalTag)) {
                return "";
            }
            return this.mGlobalTag;
        }

        public boolean isLogHeadSwitch() {
            return this.mLogHeadSwitch;
        }

        public boolean isLog2FileSwitch() {
            return this.mLog2FileSwitch;
        }

        public boolean isLogBorderSwitch() {
            return this.mLogBorderSwitch;
        }

        public boolean isSingleTagSwitch() {
            return this.mSingleTagSwitch;
        }

        public char getConsoleFilter() {
            return T[this.mConsoleFilter - 2];
        }

        public char getFileFilter() {
            return T[this.mFileFilter - 2];
        }

        public int getStackDeep() {
            return this.mStackDeep;
        }

        public int getStackOffset() {
            return this.mStackOffset;
        }

        public int getSaveDays() {
            return this.mSaveDays;
        }

        private static String getCurrentProcessName() {
            ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
            if (am == null) {
                return "";
            }
            List info = am.getRunningAppProcesses();
            if (info == null || info.size() == 0) {
                return "";
            }
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo aInfo : info) {
                if (aInfo.pid != pid || aInfo.processName == null) continue;
                return aInfo.processName;
            }
            return "";
        }

        public String toString() {
            return "process: " + this.getProcessName() + LINE_SEP + "switch: " + this.isLogSwitch() + LINE_SEP + "console: " + this.isLog2ConsoleSwitch() + LINE_SEP + "tag: " + this.getGlobalTag() + LINE_SEP + "head: " + this.isLogHeadSwitch() + LINE_SEP + "file: " + this.isLog2FileSwitch() + LINE_SEP + "dir: " + this.getDir() + LINE_SEP + "filePrefix: " + this.getFilePrefix() + LINE_SEP + "border: " + this.isLogBorderSwitch() + LINE_SEP + "singleTag: " + this.isSingleTagSwitch() + LINE_SEP + "consoleFilter: " + this.getConsoleFilter() + LINE_SEP + "fileFilter: " + this.getFileFilter() + LINE_SEP + "stackDeep: " + this.getStackDeep() + LINE_SEP + "stackOffset: " + this.getStackOffset() + LINE_SEP + "saveDays: " + this.getSaveDays() + LINE_SEP + "formatter: " + I_FORMATTER_MAP;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TYPE {
    }
}

