/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.support.annotation.RawRes;
import com.blankj.utilcode.util.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class ResourceUtils {
    private static final int BUFFER_SIZE = 8192;

    private ResourceUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean copyFileFromAssets(String assetsFilePath, String destFilePath) {
        boolean res = true;
        try {
            String[] assets = Utils.getApp().getAssets().list(assetsFilePath);
            if (assets.length > 0) {
                for (String asset : assets) {
                    res &= ResourceUtils.copyFileFromAssets(assetsFilePath + "/" + asset, destFilePath + "/" + asset);
                }
            } else {
                res = ResourceUtils.writeFileFromIS(destFilePath, Utils.getApp().getAssets().open(assetsFilePath), false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            res = false;
        }
        return res;
    }

    public static String readAssets2String(String assetsFilePath) {
        return ResourceUtils.readAssets2String(assetsFilePath, null);
    }

    public static String readAssets2String(String assetsFilePath, String charsetName) {
        InputStream is;
        try {
            is = Utils.getApp().getAssets().open(assetsFilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        byte[] bytes = ResourceUtils.is2Bytes(is);
        if (bytes == null) {
            return null;
        }
        if (ResourceUtils.isSpace(charsetName)) {
            return new String(bytes);
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static List<String> readAssets2List(String assetsPath) {
        return ResourceUtils.readAssets2List(assetsPath, null);
    }

    public static List<String> readAssets2List(String assetsPath, String charsetName) {
        try {
            return ResourceUtils.is2List(Utils.getApp().getResources().getAssets().open(assetsPath), charsetName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean copyFileFromRaw(@RawRes int resId, String destFilePath) {
        return ResourceUtils.writeFileFromIS(destFilePath, Utils.getApp().getResources().openRawResource(resId), false);
    }

    public static String readRaw2String(@RawRes int resId) {
        return ResourceUtils.readRaw2String(resId, null);
    }

    public static String readRaw2String(@RawRes int resId, String charsetName) {
        InputStream is = Utils.getApp().getResources().openRawResource(resId);
        byte[] bytes = ResourceUtils.is2Bytes(is);
        if (bytes == null) {
            return null;
        }
        if (ResourceUtils.isSpace(charsetName)) {
            return new String(bytes);
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static List<String> readRaw2List(@RawRes int resId) {
        return ResourceUtils.readRaw2List(resId, null);
    }

    public static List<String> readRaw2List(@RawRes int resId, String charsetName) {
        return ResourceUtils.is2List(Utils.getApp().getResources().openRawResource(resId), charsetName);
    }

    private static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return ResourceUtils.writeFileFromIS(ResourceUtils.getFileByPath(filePath), is, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        if (!ResourceUtils.createOrExistsFile(file) || is == null) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[8192];
            while ((len = is.read(data, 0, 8192)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File getFileByPath(String filePath) {
        return ResourceUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!ResourceUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] is2Bytes(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            int len;
            os = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            while ((len = is.read(b, 0, 8192)) != -1) {
                os.write(b, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> is2List(InputStream is, String charsetName) {
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = ResourceUtils.isSpace(charsetName) ? new BufferedReader(new InputStreamReader(is)) : new BufferedReader(new InputStreamReader(is, charsetName));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

