/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.blankj.utilcode.constant.CacheConstants;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

public final class CacheDiskUtils
implements CacheConstants {
    private static final long DEFAULT_MAX_SIZE = Long.MAX_VALUE;
    private static final int DEFAULT_MAX_COUNT = Integer.MAX_VALUE;
    private static final String CACHE_PREFIX = "cdu_";
    private static final String TYPE_BYTE = "by_";
    private static final String TYPE_STRING = "st_";
    private static final String TYPE_JSON_OBJECT = "jo_";
    private static final String TYPE_JSON_ARRAY = "ja_";
    private static final String TYPE_BITMAP = "bi_";
    private static final String TYPE_DRAWABLE = "dr_";
    private static final String TYPE_PARCELABLE = "pa_";
    private static final String TYPE_SERIALIZABLE = "se_";
    private static final Map<String, CacheDiskUtils> CACHE_MAP = new HashMap<String, CacheDiskUtils>();
    private final String mCacheKey;
    private final File mCacheDir;
    private final long mMaxSize;
    private final int mMaxCount;
    private DiskCacheManager mDiskCacheManager;

    public static CacheDiskUtils getInstance() {
        return CacheDiskUtils.getInstance("", Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheDiskUtils getInstance(String cacheName) {
        return CacheDiskUtils.getInstance(cacheName, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static CacheDiskUtils getInstance(long maxSize, int maxCount) {
        return CacheDiskUtils.getInstance("", maxSize, maxCount);
    }

    public static CacheDiskUtils getInstance(String cacheName, long maxSize, int maxCount) {
        if (UtilsBridge.isSpace(cacheName)) {
            cacheName = "cacheUtils";
        }
        File file = new File(Utils.getApp().getCacheDir(), cacheName);
        return CacheDiskUtils.getInstance(file, maxSize, maxCount);
    }

    public static CacheDiskUtils getInstance(@NonNull File cacheDir) {
        return CacheDiskUtils.getInstance(cacheDir, Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheDiskUtils getInstance(@NonNull File cacheDir, long maxSize, int maxCount) {
        String cacheKey = cacheDir.getAbsoluteFile() + "_" + maxSize + "_" + maxCount;
        CacheDiskUtils cache = CACHE_MAP.get(cacheKey);
        if (cache != null) return cache;
        Class<CacheDiskUtils> clazz = CacheDiskUtils.class;
        synchronized (CacheDiskUtils.class) {
            cache = CACHE_MAP.get(cacheKey);
            if (cache != null) return cache;
            cache = new CacheDiskUtils(cacheKey, cacheDir, maxSize, maxCount);
            CACHE_MAP.put(cacheKey, cache);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return cache;
        }
    }

    private CacheDiskUtils(String cacheKey, File cacheDir, long maxSize, int maxCount) {
        this.mCacheKey = cacheKey;
        this.mCacheDir = cacheDir;
        this.mMaxSize = maxSize;
        this.mMaxCount = maxCount;
    }

    private DiskCacheManager getDiskCacheManager() {
        if (this.mCacheDir.exists()) {
            if (this.mDiskCacheManager == null) {
                this.mDiskCacheManager = new DiskCacheManager(this.mCacheDir, this.mMaxSize, this.mMaxCount);
            }
        } else if (this.mCacheDir.mkdirs()) {
            this.mDiskCacheManager = new DiskCacheManager(this.mCacheDir, this.mMaxSize, this.mMaxCount);
        } else {
            Log.e((String)"CacheDiskUtils", (String)("can't make dirs in " + this.mCacheDir.getAbsolutePath()));
        }
        return this.mDiskCacheManager;
    }

    public String toString() {
        return this.mCacheKey + "@" + Integer.toHexString(this.hashCode());
    }

    public void put(@NonNull String key, byte[] value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, byte[] value, int saveTime) {
        this.realPutBytes(TYPE_BYTE + key, value, saveTime);
    }

    private void realPutBytes(String key, byte[] value, int saveTime) {
        if (value == null) {
            return;
        }
        DiskCacheManager diskCacheManager = this.getDiskCacheManager();
        if (diskCacheManager == null) {
            return;
        }
        if (saveTime >= 0) {
            value = DiskCacheHelper.newByteArrayWithTime(saveTime, value);
        }
        File file = diskCacheManager.getFileBeforePut(key);
        UtilsBridge.writeFileFromBytes(file, value);
        diskCacheManager.updateModify(file);
        diskCacheManager.put(file);
    }

    public byte[] getBytes(@NonNull String key) {
        return this.getBytes(key, null);
    }

    public byte[] getBytes(@NonNull String key, byte[] defaultValue) {
        return this.realGetBytes(TYPE_BYTE + key, defaultValue);
    }

    private byte[] realGetBytes(@NonNull String key) {
        return this.realGetBytes(key, null);
    }

    private byte[] realGetBytes(@NonNull String key, byte[] defaultValue) {
        DiskCacheManager diskCacheManager = this.getDiskCacheManager();
        if (diskCacheManager == null) {
            return defaultValue;
        }
        File file = diskCacheManager.getFileIfExists(key);
        if (file == null) {
            return defaultValue;
        }
        byte[] data = UtilsBridge.readFile2Bytes(file);
        if (DiskCacheHelper.isDue(data)) {
            diskCacheManager.removeByKey(key);
            return defaultValue;
        }
        diskCacheManager.updateModify(file);
        return DiskCacheHelper.getDataWithoutDueTime(data);
    }

    public void put(@NonNull String key, String value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, String value, int saveTime) {
        this.realPutBytes(TYPE_STRING + key, UtilsBridge.string2Bytes(value), saveTime);
    }

    public String getString(@NonNull String key) {
        return this.getString(key, null);
    }

    public String getString(@NonNull String key, String defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_STRING + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2String(bytes);
    }

    public void put(@NonNull String key, JSONObject value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, JSONObject value, int saveTime) {
        this.realPutBytes(TYPE_JSON_OBJECT + key, UtilsBridge.jsonObject2Bytes(value), saveTime);
    }

    public JSONObject getJSONObject(@NonNull String key) {
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(@NonNull String key, JSONObject defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_JSON_OBJECT + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2JSONObject(bytes);
    }

    public void put(@NonNull String key, JSONArray value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, JSONArray value, int saveTime) {
        this.realPutBytes(TYPE_JSON_ARRAY + key, UtilsBridge.jsonArray2Bytes(value), saveTime);
    }

    public JSONArray getJSONArray(@NonNull String key) {
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(@NonNull String key, JSONArray defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_JSON_ARRAY + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2JSONArray(bytes);
    }

    public void put(@NonNull String key, Bitmap value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Bitmap value, int saveTime) {
        this.realPutBytes(TYPE_BITMAP + key, UtilsBridge.bitmap2Bytes(value), saveTime);
    }

    public Bitmap getBitmap(@NonNull String key) {
        return this.getBitmap(key, null);
    }

    public Bitmap getBitmap(@NonNull String key, Bitmap defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_BITMAP + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2Bitmap(bytes);
    }

    public void put(@NonNull String key, Drawable value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Drawable value, int saveTime) {
        this.realPutBytes(TYPE_DRAWABLE + key, UtilsBridge.drawable2Bytes(value), saveTime);
    }

    public Drawable getDrawable(@NonNull String key) {
        return this.getDrawable(key, null);
    }

    public Drawable getDrawable(@NonNull String key, Drawable defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_DRAWABLE + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2Drawable(bytes);
    }

    public void put(@NonNull String key, Parcelable value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Parcelable value, int saveTime) {
        this.realPutBytes(TYPE_PARCELABLE + key, UtilsBridge.parcelable2Bytes(value), saveTime);
    }

    public <T> T getParcelable(@NonNull String key, @NonNull Parcelable.Creator<T> creator) {
        return this.getParcelable(key, creator, null);
    }

    public <T> T getParcelable(@NonNull String key, @NonNull Parcelable.Creator<T> creator, T defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_PARCELABLE + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2Parcelable(bytes, creator);
    }

    public void put(@NonNull String key, Serializable value) {
        this.put(key, value, -1);
    }

    public void put(@NonNull String key, Serializable value, int saveTime) {
        this.realPutBytes(TYPE_SERIALIZABLE + key, UtilsBridge.serializable2Bytes(value), saveTime);
    }

    public Object getSerializable(@NonNull String key) {
        return this.getSerializable(key, null);
    }

    public Object getSerializable(@NonNull String key, Object defaultValue) {
        byte[] bytes = this.realGetBytes(TYPE_SERIALIZABLE + key);
        if (bytes == null) {
            return defaultValue;
        }
        return UtilsBridge.bytes2Object(bytes);
    }

    public long getCacheSize() {
        DiskCacheManager diskCacheManager = this.getDiskCacheManager();
        if (diskCacheManager == null) {
            return 0L;
        }
        return diskCacheManager.getCacheSize();
    }

    public int getCacheCount() {
        DiskCacheManager diskCacheManager = this.getDiskCacheManager();
        if (diskCacheManager == null) {
            return 0;
        }
        return diskCacheManager.getCacheCount();
    }

    public boolean remove(@NonNull String key) {
        DiskCacheManager diskCacheManager = this.getDiskCacheManager();
        if (diskCacheManager == null) {
            return true;
        }
        return diskCacheManager.removeByKey(TYPE_BYTE + key) && diskCacheManager.removeByKey(TYPE_STRING + key) && diskCacheManager.removeByKey(TYPE_JSON_OBJECT + key) && diskCacheManager.removeByKey(TYPE_JSON_ARRAY + key) && diskCacheManager.removeByKey(TYPE_BITMAP + key) && diskCacheManager.removeByKey(TYPE_DRAWABLE + key) && diskCacheManager.removeByKey(TYPE_PARCELABLE + key) && diskCacheManager.removeByKey(TYPE_SERIALIZABLE + key);
    }

    public boolean clear() {
        DiskCacheManager diskCacheManager = this.getDiskCacheManager();
        if (diskCacheManager == null) {
            return true;
        }
        return diskCacheManager.clear();
    }

    private static final class DiskCacheHelper {
        static final int TIME_INFO_LEN = 14;

        private DiskCacheHelper() {
        }

        private static byte[] newByteArrayWithTime(int second, byte[] data) {
            byte[] time = DiskCacheHelper.createDueTime(second).getBytes();
            byte[] content = new byte[time.length + data.length];
            System.arraycopy(time, 0, content, 0, time.length);
            System.arraycopy(data, 0, content, time.length, data.length);
            return content;
        }

        private static String createDueTime(int seconds) {
            return String.format(Locale.getDefault(), "_$%010d$_", System.currentTimeMillis() / 1000L + (long)seconds);
        }

        private static boolean isDue(byte[] data) {
            long millis = DiskCacheHelper.getDueTime(data);
            return millis != -1L && System.currentTimeMillis() > millis;
        }

        private static long getDueTime(byte[] data) {
            if (DiskCacheHelper.hasTimeInfo(data)) {
                String millis = new String(DiskCacheHelper.copyOfRange(data, 2, 12));
                try {
                    return Long.parseLong(millis) * 1000L;
                }
                catch (NumberFormatException e) {
                    return -1L;
                }
            }
            return -1L;
        }

        private static byte[] getDataWithoutDueTime(byte[] data) {
            if (DiskCacheHelper.hasTimeInfo(data)) {
                return DiskCacheHelper.copyOfRange(data, 14, data.length);
            }
            return data;
        }

        private static byte[] copyOfRange(byte[] original, int from, int to) {
            int newLength = to - from;
            if (newLength < 0) {
                throw new IllegalArgumentException(from + " > " + to);
            }
            byte[] copy = new byte[newLength];
            System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
            return copy;
        }

        private static boolean hasTimeInfo(byte[] data) {
            return data != null && data.length >= 14 && data[0] == 95 && data[1] == 36 && data[12] == 36 && data[13] == 95;
        }
    }

    private static final class DiskCacheManager {
        private final AtomicLong cacheSize;
        private final AtomicInteger cacheCount;
        private final long sizeLimit;
        private final int countLimit;
        private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
        private final File cacheDir;
        private final Thread mThread;

        private DiskCacheManager(final File cacheDir, long sizeLimit, int countLimit) {
            this.cacheDir = cacheDir;
            this.sizeLimit = sizeLimit;
            this.countLimit = countLimit;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int size = 0;
                    int count = 0;
                    File[] cachedFiles = cacheDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith(CacheDiskUtils.CACHE_PREFIX);
                        }
                    });
                    if (cachedFiles != null) {
                        for (File cachedFile : cachedFiles) {
                            size = (int)((long)size + cachedFile.length());
                            ++count;
                            lastUsageDates.put(cachedFile, cachedFile.lastModified());
                        }
                        cacheSize.getAndAdd(size);
                        cacheCount.getAndAdd(count);
                    }
                }
            });
            this.mThread.start();
        }

        private long getCacheSize() {
            this.wait2InitOk();
            return this.cacheSize.get();
        }

        private int getCacheCount() {
            this.wait2InitOk();
            return this.cacheCount.get();
        }

        private File getFileBeforePut(String key) {
            this.wait2InitOk();
            File file = new File(this.cacheDir, this.getCacheNameByKey(key));
            if (file.exists()) {
                this.cacheCount.addAndGet(-1);
                this.cacheSize.addAndGet(-file.length());
            }
            return file;
        }

        private void wait2InitOk() {
            try {
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private File getFileIfExists(String key) {
            File file = new File(this.cacheDir, this.getCacheNameByKey(key));
            if (!file.exists()) {
                return null;
            }
            return file;
        }

        private String getCacheNameByKey(String key) {
            return CacheDiskUtils.CACHE_PREFIX + key.substring(0, 3) + key.substring(3).hashCode();
        }

        private void put(File file) {
            this.cacheCount.addAndGet(1);
            this.cacheSize.addAndGet(file.length());
            while (this.cacheCount.get() > this.countLimit || this.cacheSize.get() > this.sizeLimit) {
                this.cacheSize.addAndGet(-this.removeOldest());
                this.cacheCount.addAndGet(-1);
            }
        }

        private void updateModify(File file) {
            Long millis = System.currentTimeMillis();
            file.setLastModified(millis);
            this.lastUsageDates.put(file, millis);
        }

        private boolean removeByKey(String key) {
            File file = this.getFileIfExists(key);
            if (file == null) {
                return true;
            }
            if (!file.delete()) {
                return false;
            }
            this.cacheSize.addAndGet(-file.length());
            this.cacheCount.addAndGet(-1);
            this.lastUsageDates.remove(file);
            return true;
        }

        private boolean clear() {
            File[] files = this.cacheDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(CacheDiskUtils.CACHE_PREFIX);
                }
            });
            if (files == null || files.length <= 0) {
                return true;
            }
            boolean flag = true;
            for (File file : files) {
                if (!file.delete()) {
                    flag = false;
                    continue;
                }
                this.cacheSize.addAndGet(-file.length());
                this.cacheCount.addAndGet(-1);
                this.lastUsageDates.remove(file);
            }
            if (flag) {
                this.lastUsageDates.clear();
                this.cacheSize.set(0L);
                this.cacheCount.set(0);
            }
            return flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long removeOldest() {
            if (this.lastUsageDates.isEmpty()) {
                return 0L;
            }
            Long oldestUsage = Long.MAX_VALUE;
            File oldestFile = null;
            Set<Map.Entry<File, Long>> entries = this.lastUsageDates.entrySet();
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                for (Map.Entry<File, Long> entry : entries) {
                    Long lastValueUsage = entry.getValue();
                    if (lastValueUsage >= oldestUsage) continue;
                    oldestUsage = lastValueUsage;
                    oldestFile = entry.getKey();
                }
            }
            if (oldestFile == null) {
                return 0L;
            }
            long fileSize = oldestFile.length();
            if (oldestFile.delete()) {
                this.lastUsageDates.remove(oldestFile);
                return fileSize;
            }
            return 0L;
        }
    }
}

