/*
 * Decompiled with CFR 0.152.
 */
package com.jpegkit;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.nio.ByteBuffer;

public class Jpeg
implements Parcelable {
    private static final Object sJniLock = new Object();
    private ByteBuffer mHandle;
    public static final Parcelable.Creator<Jpeg> CREATOR;

    private Jpeg() {
    }

    public Jpeg(@NonNull byte[] jpegBytes) {
        this.mount(jpegBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mount(byte[] jpegBytes) {
        Object object = sJniLock;
        synchronized (object) {
            this.mHandle = this.jniMount(jpegBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public byte[] getJpegBytes() {
        Object object = sJniLock;
        synchronized (object) {
            return this.jniGetJpegBytes(this.mHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJpegSize() {
        Object object = sJniLock;
        synchronized (object) {
            return this.jniGetJpegSize(this.mHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = sJniLock;
        synchronized (object) {
            return this.jniGetWidth(this.mHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = sJniLock;
        synchronized (object) {
            return this.jniGetHeight(this.mHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(int degrees) {
        Object object = sJniLock;
        synchronized (object) {
            this.jniRotate(this.mHandle, degrees);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flipHorizontal() {
        Object object = sJniLock;
        synchronized (object) {
            this.jniFlipHorizontal(this.mHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flipVertical() {
        Object object = sJniLock;
        synchronized (object) {
            this.jniFlipVertical(this.mHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crop(Rect crop) {
        Object object = sJniLock;
        synchronized (object) {
            this.jniCrop(this.mHandle, crop.left, crop.top, crop.width(), crop.height());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = sJniLock;
        synchronized (object) {
            this.jniRelease(this.mHandle);
        }
    }

    private native ByteBuffer jniMount(byte[] var1);

    private native byte[] jniGetJpegBytes(ByteBuffer var1);

    private native long jniGetJpegSize(ByteBuffer var1);

    private native int jniGetWidth(ByteBuffer var1);

    private native int jniGetHeight(ByteBuffer var1);

    private native void jniRotate(ByteBuffer var1, int var2);

    private native void jniFlipHorizontal(ByteBuffer var1);

    private native void jniFlipVertical(ByteBuffer var1);

    private native void jniCrop(ByteBuffer var1, int var2, int var3, int var4, int var5);

    private native void jniRelease(ByteBuffer var1);

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        byte[] jpegBytes = this.getJpegBytes();
        dest.writeInt(jpegBytes.length);
        dest.writeByteArray(jpegBytes);
    }

    static {
        System.loadLibrary("jpegkit");
        CREATOR = new Parcelable.Creator<Jpeg>(){

            public Jpeg createFromParcel(Parcel in) {
                int length = in.readInt();
                byte[] jpegBytes = new byte[length];
                in.readByteArray(jpegBytes);
                return new Jpeg(jpegBytes);
            }

            public Jpeg[] newArray(int size) {
                return new Jpeg[size];
            }
        };
    }
}

