/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi;

import com.codingapi.txlcn.spi.message.ClientInitCallBack;
import com.codingapi.txlcn.spi.message.RpcAnswer;
import com.codingapi.txlcn.spi.message.RpcConfig;
import com.codingapi.txlcn.spi.message.loadbalance.RpcLoadBalance;
import com.codingapi.txlcn.spi.message.netty.loadbalance.RandomLoadBalance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
public class MessageConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="tx-lcn.message.netty")
    public RpcConfig rpcConfig() {
        return new RpcConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public RpcAnswer rpcClientAnswer() {
        return rpcCmd -> log.info("cmd->{}", (Object)rpcCmd);
    }

    @Bean
    @ConditionalOnMissingBean
    public RpcLoadBalance rpcLoadBalance() {
        return new RandomLoadBalance();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientInitCallBack clientInitCallBack() {
        return remoteKey -> log.info("connected->{}", (Object)remoteKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageConfiguration;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "MessageConfiguration()";
    }
}

