/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.bean;

import com.codingapi.txlcn.commons.util.RandomUtils;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.netty.bean.RpcCmdContext;
import com.codingapi.txlcn.spi.message.netty.bean.RpcContent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRpcCmd
extends RpcCmd {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcCmd.class);
    private volatile transient RpcContent rpcContent;

    public String randomKey() {
        String key = RandomUtils.randomKey();
        if (RpcCmdContext.getInstance().hasKey(key)) {
            return this.randomKey();
        }
        this.rpcContent = RpcCmdContext.getInstance().addKey(key);
        return key;
    }

    public MessageDto loadResult() throws RpcException {
        MessageDto msg = this.rpcContent.getRes();
        if (msg == null) {
            throw new RpcException("request timeout.");
        }
        log.debug("got response. {} ", (Object)this.getKey());
        return msg;
    }

    public RpcContent loadRpcContent() {
        if (this.rpcContent == null) {
            this.rpcContent = RpcCmdContext.getInstance().getKey(this.getKey());
        }
        return this.rpcContent;
    }

    public void await() {
        if (Objects.nonNull(this.rpcContent.getRes())) {
            return;
        }
        this.rpcContent.await();
    }
}

