/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.bean;

import com.codingapi.txlcn.spi.message.RpcConfig;
import com.codingapi.txlcn.spi.message.netty.bean.RpcContent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCmdContext {
    private static final Logger log = LoggerFactory.getLogger(RpcCmdContext.class);
    private int cacheSize = 1024;
    private int waitTime = 1;
    private static RpcCmdContext context = null;
    private Map<String, RpcContent> map = new ConcurrentHashMap<String, RpcContent>();
    private List<RpcContent> cacheList = new CopyOnWriteArrayList<RpcContent>();
    private final LinkedList<RpcContent> freeList = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RpcCmdContext getInstance() {
        if (context != null) return context;
        Class<RpcCmdContext> clazz = RpcCmdContext.class;
        synchronized (RpcCmdContext.class) {
            if (context != null) return context;
            context = new RpcCmdContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return context;
        }
    }

    private RpcCmdContext() {
    }

    public synchronized boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    public synchronized RpcContent addKey(String key) {
        RpcContent rpcContent = this.createRpcContent();
        this.map.put(key, rpcContent);
        return rpcContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcContent findRpcContent() {
        LinkedList<RpcContent> linkedList = this.freeList;
        synchronized (linkedList) {
            RpcContent cacheContent = this.freeList.getFirst();
            if (!cacheContent.isUsed()) {
                cacheContent.init();
                this.freeList.remove(cacheContent);
                return cacheContent;
            }
        }
        RpcContent rpcContent = new RpcContent(this.getWaitTime());
        rpcContent.init();
        return rpcContent;
    }

    private RpcContent createRpcContent() {
        if (this.cacheList.size() < this.cacheSize) {
            RpcContent rpcContent = new RpcContent(this.getWaitTime());
            rpcContent.init();
            this.cacheList.add(rpcContent);
            return rpcContent;
        }
        return this.findRpcContent();
    }

    public RpcContent getKey(String key) {
        RpcContent rpcContent = this.map.get(key);
        this.clearKey(key);
        return rpcContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearKey(String key) {
        RpcContent rpcContent = this.map.get(key);
        if (this.cacheList.contains(rpcContent)) {
            LinkedList<RpcContent> linkedList = this.freeList;
            synchronized (linkedList) {
                this.freeList.add(rpcContent);
            }
        }
        this.map.remove(key);
    }

    public void setRpcConfig(RpcConfig rpcConfig) {
        this.cacheSize = rpcConfig.getCacheSize();
        this.waitTime = (int)rpcConfig.getWaitTime() / 1000;
    }

    public int getWaitTime() {
        return this.waitTime;
    }
}

