/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.bean;

import com.codingapi.txlcn.spi.message.dto.MessageDto;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RpcContent {
    private int seconds;
    private volatile MessageDto res;
    private Condition condition;
    private Lock lock;
    private volatile boolean used = false;

    public void init() {
        this.used = true;
    }

    public void clear() {
        this.used = false;
        this.res = null;
    }

    public boolean isUsed() {
        return this.used;
    }

    public RpcContent(int seconds) {
        this.seconds = seconds;
        this.lock = new ReentrantLock(true);
        this.condition = this.lock.newCondition();
    }

    public void await() {
        try {
            this.lock.lock();
            try {
                this.condition.await(this.seconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signal() {
        try {
            this.lock.lock();
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDto getRes() {
        RpcContent rpcContent = this;
        synchronized (rpcContent) {
            return this.res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRes(MessageDto res) {
        RpcContent rpcContent = this;
        synchronized (rpcContent) {
            this.res = res;
        }
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }
}

