/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.bean;

import com.codingapi.txlcn.spi.message.RpcConfig;
import com.codingapi.txlcn.spi.message.dto.AppInfo;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.dto.RpcResponseState;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.netty.bean.NettyRpcCmd;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketManager {
    private static final Logger log = LoggerFactory.getLogger(SocketManager.class);
    private Map<String, AppInfo> appNames;
    private ScheduledExecutorService executorService;
    private ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private static SocketManager manager = null;
    private long attrDelayTime = 60000L;

    private SocketManager() {
        this.appNames = new ConcurrentHashMap<String, AppInfo>();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketManager getInstance() {
        if (manager != null) return manager;
        Class<SocketManager> clazz = SocketManager.class;
        synchronized (SocketManager.class) {
            if (manager != null) return manager;
            manager = new SocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public void addChannel(Channel channel) {
        this.channels.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.channels.remove((Object)channel);
        try {
            this.executorService.schedule(() -> {
                String key = channel.remoteAddress().toString();
                this.appNames.remove(key);
            }, this.attrDelayTime, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private Channel getChannel(String key) throws RpcException {
        for (Channel channel : this.channels) {
            String val = channel.remoteAddress().toString();
            if (!key.equals(val)) continue;
            return channel;
        }
        throw new RpcException("channel not online.");
    }

    public RpcResponseState send(String key, RpcCmd cmd) throws RpcException {
        Channel channel = this.getChannel(key);
        ChannelFuture future = channel.writeAndFlush((Object)cmd).syncUninterruptibly();
        return future.isSuccess() ? RpcResponseState.success : RpcResponseState.fail;
    }

    public MessageDto request(String key, RpcCmd cmd) throws RpcException {
        NettyRpcCmd nettyRpcCmd = (NettyRpcCmd)cmd;
        log.debug("get channel, key:{}", (Object)key);
        Channel channel = this.getChannel(key);
        log.debug("write and flush sync");
        channel.writeAndFlush((Object)nettyRpcCmd);
        log.debug("await response");
        nettyRpcCmd.await();
        MessageDto res = cmd.loadResult();
        nettyRpcCmd.loadRpcContent().clear();
        return res;
    }

    public List<String> loadAllRemoteKey() {
        ArrayList<String> allKeys = new ArrayList<String>();
        for (Channel channel : this.channels) {
            allKeys.add(channel.remoteAddress().toString());
        }
        return allKeys;
    }

    public ChannelGroup getChannels() {
        return this.channels;
    }

    public int currentSize() {
        return this.channels.size();
    }

    public boolean noConnect(SocketAddress socketAddress) {
        for (Channel channel : this.channels) {
            if (!channel.remoteAddress().toString().equals(socketAddress.toString())) continue;
            return false;
        }
        return true;
    }

    public List<String> removeKeys(String moduleName) {
        ArrayList<String> allKeys = new ArrayList<String>();
        for (Channel channel : this.channels) {
            if (!this.getModuleName(channel).equals(moduleName)) continue;
            allKeys.add(channel.remoteAddress().toString());
        }
        return allKeys;
    }

    public void bindModuleName(String remoteKey, String moduleName) {
        AppInfo appInfo = new AppInfo();
        appInfo.setName(moduleName);
        appInfo.setCreateTime(new Date());
        this.appNames.put(remoteKey, appInfo);
    }

    public void setRpcConfig(RpcConfig rpcConfig) {
        this.attrDelayTime = rpcConfig.getAttrDelayTime();
    }

    public String getModuleName(Channel channel) {
        String key = channel.remoteAddress().toString();
        return this.getModuleName(key);
    }

    public String getModuleName(String remoteKey) {
        AppInfo appInfo = this.appNames.get(remoteKey);
        return appInfo == null ? null : appInfo.getName();
    }

    public List<AppInfo> appInfos() {
        return new ArrayList<AppInfo>(this.appNames.values());
    }
}

