/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.handler;

import com.codingapi.txlcn.commons.util.RandomUtils;
import com.codingapi.txlcn.spi.message.ClientInitCallBack;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.spi.message.netty.bean.SocketManager;
import com.codingapi.txlcn.spi.message.netty.impl.NettyContext;
import com.codingapi.txlcn.spi.message.netty.impl.NettyRpcClientInitializer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class NettyClientRetryHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(NettyClientRetryHandler.class);
    @Autowired
    private NettyRpcClientInitializer nettyRpcClientInitializer;
    @Autowired
    private ClientInitCallBack clientInitCallBack;
    private int keepSize;
    private NettyRpcCmd heartCmd;

    public NettyClientRetryHandler() {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("heartCheck");
        this.heartCmd = new NettyRpcCmd();
        this.heartCmd.setMsg(messageDto);
        this.heartCmd.setKey(RandomUtils.randomKey());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.keepSize = NettyContext.currentParam(List.class).size();
        this.clientInitCallBack.connected(ctx.channel().remoteAddress().toString());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        log.error("keepSize:{},nowSize:{}", (Object)this.keepSize, (Object)SocketManager.getInstance().currentSize());
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        log.error("socketAddress:{} ", (Object)socketAddress);
        this.nettyRpcClientInitializer.connect(socketAddress);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("NettyClientRetryHandler - exception . ", cause);
        if (cause instanceof ConnectException) {
            int size = SocketManager.getInstance().currentSize();
            Thread.sleep(15000L);
            log.error("current size:{}  ", (Object)size);
            log.error("try connect tx-manager:{} ", (Object)ctx.channel().remoteAddress());
            this.nettyRpcClientInitializer.connect(ctx.channel().remoteAddress());
        }
        ctx.writeAndFlush((Object)this.heartCmd);
    }
}

