/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.handler;

import com.codingapi.txlcn.spi.message.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.spi.message.netty.bean.RpcContent;
import com.codingapi.txlcn.spi.message.netty.em.NettyType;
import com.codingapi.txlcn.spi.message.netty.impl.NettyContext;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@ChannelHandler.Sharable
public class RpcCmdDecoder
extends SimpleChannelInboundHandler<NettyRpcCmd> {
    private static final Logger log = LoggerFactory.getLogger(RpcCmdDecoder.class);

    protected void channelRead0(ChannelHandlerContext ctx, NettyRpcCmd cmd) {
        String key = cmd.getKey();
        log.debug("cmd->{}", (Object)cmd);
        if (cmd.getMsg() != null && "heartCheck".equals(cmd.getMsg().getAction())) {
            if (NettyContext.currentType().equals((Object)NettyType.client)) {
                ctx.writeAndFlush((Object)cmd);
                return;
            }
            return;
        }
        if (!StringUtils.isEmpty((Object)key)) {
            RpcContent rpcContent = cmd.loadRpcContent();
            if (rpcContent != null) {
                log.debug("got response message");
                rpcContent.setRes(cmd.getMsg());
                rpcContent.signal();
            } else {
                ctx.fireChannelRead((Object)cmd);
            }
        } else {
            ctx.fireChannelRead((Object)cmd);
        }
    }
}

