/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.handler;

import com.codingapi.txlcn.commons.util.RandomUtils;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.spi.message.netty.bean.SocketManager;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class SocketManagerInitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SocketManagerInitHandler.class);
    private RpcCmd heartCmd;

    public SocketManagerInitHandler() {
        MessageDto messageDto = new MessageDto();
        messageDto.setAction("heartCheck");
        this.heartCmd = new NettyRpcCmd();
        this.heartCmd.setMsg(messageDto);
        this.heartCmd.setKey(RandomUtils.randomKey());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        SocketManager.getInstance().addChannel(ctx.channel());
        log.info("Connected: {}", (Object)ctx.channel().remoteAddress());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        SocketManager.getInstance().removeChannel(ctx.channel());
        log.error("Disconnected: {}", (Object)ctx.channel().remoteAddress());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && (event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            ctx.writeAndFlush((Object)this.heartCmd);
        }
    }
}

