/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.impl;

import com.codingapi.txlcn.spi.message.RpcClient;
import com.codingapi.txlcn.spi.message.dto.AppInfo;
import com.codingapi.txlcn.spi.message.dto.MessageDto;
import com.codingapi.txlcn.spi.message.dto.RpcCmd;
import com.codingapi.txlcn.spi.message.dto.RpcResponseState;
import com.codingapi.txlcn.spi.message.exception.RpcException;
import com.codingapi.txlcn.spi.message.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.spi.message.netty.bean.SocketManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NettyRpcClient
extends RpcClient {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcClient.class);

    public RpcResponseState send(RpcCmd rpcCmd) throws RpcException {
        return SocketManager.getInstance().send(rpcCmd.getRemoteKey(), rpcCmd);
    }

    public RpcResponseState send(String remoteKey, MessageDto msg) throws RpcException {
        NettyRpcCmd rpcCmd = new NettyRpcCmd();
        rpcCmd.setMsg(msg);
        rpcCmd.setRemoteKey(remoteKey);
        return this.send(rpcCmd);
    }

    public MessageDto request(RpcCmd rpcCmd) throws RpcException {
        if (rpcCmd.getKey() == null) {
            throw new RpcException("key not null.");
        }
        return SocketManager.getInstance().request(rpcCmd.getRemoteKey(), rpcCmd);
    }

    public MessageDto request(String remoteKey, MessageDto msg) throws RpcException {
        long startTime = System.currentTimeMillis();
        NettyRpcCmd rpcCmd = new NettyRpcCmd();
        rpcCmd.setMsg(msg);
        String key = rpcCmd.randomKey();
        rpcCmd.setKey(key);
        rpcCmd.setRemoteKey(remoteKey);
        MessageDto result = this.request(rpcCmd);
        log.debug("cmd request used time: {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    public List<String> loadAllRemoteKey() {
        return SocketManager.getInstance().loadAllRemoteKey();
    }

    public List<String> remoteKeys(String moduleName) {
        return SocketManager.getInstance().removeKeys(moduleName);
    }

    public void bindAppName(String remoteKey, String appName) {
        SocketManager.getInstance().bindModuleName(remoteKey, appName);
    }

    public String getAppName(String remoteKey) {
        return SocketManager.getInstance().getModuleName(remoteKey);
    }

    public List<AppInfo> apps() {
        return SocketManager.getInstance().appInfos();
    }
}

