/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.impl;

import com.codingapi.txlcn.spi.message.RpcClientInitializer;
import com.codingapi.txlcn.spi.message.RpcConfig;
import com.codingapi.txlcn.spi.message.dto.TxManagerHost;
import com.codingapi.txlcn.spi.message.netty.bean.SocketManager;
import com.codingapi.txlcn.spi.message.netty.em.NettyType;
import com.codingapi.txlcn.spi.message.netty.handler.NettyRpcClientHandlerInitHandler;
import com.codingapi.txlcn.spi.message.netty.impl.NettyContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NettyRpcClientInitializer
implements RpcClientInitializer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcClientInitializer.class);
    @Autowired
    private NettyRpcClientHandlerInitHandler nettyRpcClientHandlerInitHandler;
    @Autowired
    private RpcConfig rpcConfig;
    private EventLoopGroup workerGroup;
    private CountDownLatch countDownLatch;

    public void init(List<TxManagerHost> hosts) {
        NettyContext.type = NettyType.client;
        NettyContext.params = hosts;
        this.workerGroup = new NioEventLoopGroup();
        this.countDownLatch = new CountDownLatch(hosts.size());
        for (TxManagerHost host : hosts) {
            this.connect(new InetSocketAddress(host.getHost(), host.getPort()));
        }
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        log.info("TM cluster size:{}", (Object)SocketManager.getInstance().currentSize());
    }

    public synchronized void connect(SocketAddress socketAddress) {
        boolean connected = false;
        for (int i = 0; i < this.rpcConfig.getReconnectCount(); ++i) {
            if (!SocketManager.getInstance().noConnect(socketAddress)) continue;
            try {
                log.info("Connect TM[{}] - count {}", (Object)socketAddress, (Object)(i + 1));
                Bootstrap b = new Bootstrap();
                b.group(this.workerGroup);
                b.channel(NioSocketChannel.class);
                b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
                b.handler((ChannelHandler)this.nettyRpcClientHandlerInitHandler);
                ChannelFuture channelFuture = b.connect(socketAddress).syncUninterruptibly();
                channelFuture.addListener(future -> this.countDownLatch.countDown());
                log.info("TC connect state:{}", (Object)socketAddress, (Object)channelFuture.isSuccess());
                connected = true;
                break;
            }
            catch (Exception e) {
                this.countDownLatch.countDown();
                log.warn("Connect TM[{}] fail. {}ms latter try again.", (Object)socketAddress, (Object)this.rpcConfig.getReconnectDelay());
                try {
                    Thread.sleep(this.rpcConfig.getReconnectDelay());
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (!connected) {
            log.warn("Finally, netty connection fail , address is {}", (Object)socketAddress);
            if (SocketManager.getInstance().currentSize() == 0) {
                throw new IllegalStateException("Can not connect any TM, DTX disabled.");
            }
        }
    }

    public void destroy() throws Exception {
        this.workerGroup.shutdownGracefully();
        log.info("TC was down.");
    }
}

