/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message.netty.impl;

import com.codingapi.txlcn.spi.message.RpcServerInitializer;
import com.codingapi.txlcn.spi.message.dto.ManagerProperties;
import com.codingapi.txlcn.spi.message.netty.em.NettyType;
import com.codingapi.txlcn.spi.message.netty.handler.NettyRpcServerHandlerInitHandler;
import com.codingapi.txlcn.spi.message.netty.impl.NettyContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NettyRpcServerInitializer
implements RpcServerInitializer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcServerInitializer.class);
    @Autowired
    private NettyRpcServerHandlerInitHandler nettyRpcServerHandlerInitHandler;
    private EventLoopGroup workerGroup;
    private NioEventLoopGroup bossGroup;

    public void init(ManagerProperties managerProperties) {
        NettyContext.type = NettyType.server;
        NettyContext.params = managerProperties;
        this.nettyRpcServerHandlerInitHandler.setManagerProperties(managerProperties);
        int port = managerProperties.getRpcPort();
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)this.nettyRpcServerHandlerInitHandler);
            b.bind(port);
            log.info("Socket started on port(s):{}(socket)", (Object)port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() throws Exception {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        log.info("server was down.");
    }
}

