/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.support.restapi.auth.sauth.token;

import com.codingapi.txlcn.tm.support.restapi.auth.sauth.SAuthHandleException;
import com.codingapi.txlcn.tm.support.restapi.auth.sauth.SAuthLogic;
import com.codingapi.txlcn.tm.support.restapi.vo.ErrorResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TokenInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TokenInterceptor.class);
    private final SAuthLogic sAuthLogic;

    @Autowired
    public TokenInterceptor(SAuthLogic sAuthLogic) {
        this.sAuthLogic = sAuthLogic;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        for (String url : this.sAuthLogic.ignoreUrls()) {
            int ind = url.indexOf("*");
            if (ind != -1 && request.getRequestURI().startsWith(url.substring(0, ind))) {
                return true;
            }
            if (!request.getRequestURI().equalsIgnoreCase(url)) continue;
            return true;
        }
        try {
            if (this.sAuthLogic.isIgnored(request)) {
                LOG.info("Ignored caused logic.");
                return true;
            }
        }
        catch (SAuthHandleException e) {
            this.responseError(HttpStatus.FORBIDDEN.value(), e.getMessage(), response);
            return false;
        }
        String token = request.getHeader("Authorization");
        if (Objects.isNull(token)) {
            token = request.getParameter("token");
        }
        if (StringUtils.isEmpty((Object)token)) {
            LOG.warn("Unauthorized, token is null. URL: " + request.getRequestURI());
            this.responseError(HttpStatus.UNAUTHORIZED.value(), "Unauthorized.", response);
            return false;
        }
        LOG.info("Token is: {}", (Object)token);
        if (!this.sAuthLogic.verify(token)) {
            LOG.warn("Unauthorized, token is invalid.");
            this.responseError(HttpStatus.UNAUTHORIZED.value(), "Unauthorized, token is invalid.", response);
            return false;
        }
        return true;
    }

    private void responseError(int code, String message, HttpServletResponse response) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setCode(code);
        errorResponse.setMessage(message);
        response.setStatus(code);
        response.setCharacterEncoding("utf8");
        try {
            response.getOutputStream().write(errorResponse.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

