/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg;

import com.codingapi.txlcn.tm.config.TxManagerConfig;
import com.codingapi.txlcn.tm.support.TxLcnManagerRpcBeanHelper;
import com.codingapi.txlcn.tm.txmsg.MessageCreator;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.LCNCmdType;
import com.codingapi.txlcn.txmsg.RpcAnswer;
import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServerRpcAnswer
implements RpcAnswer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ServerRpcAnswer.class);
    private final RpcClient rpcClient;
    private final ExecutorService executorService;
    private final TxLcnManagerRpcBeanHelper rpcBeanHelper;

    @Autowired
    public ServerRpcAnswer(RpcClient rpcClient, TxLcnManagerRpcBeanHelper rpcBeanHelper, TxManagerConfig managerConfig) {
        managerConfig.setConcurrentLevel(Math.max(Runtime.getRuntime().availableProcessors() * 5, managerConfig.getConcurrentLevel()));
        this.rpcClient = rpcClient;
        this.executorService = Executors.newFixedThreadPool(managerConfig.getConcurrentLevel(), new ThreadFactoryBuilder().setDaemon(false).setNameFormat("tm-rpc-service-%d").build());
        this.rpcBeanHelper = rpcBeanHelper;
    }

    public void callback(RpcCmd rpcCmd) {
        this.executorService.submit(() -> {
            block17: {
                try {
                    TransactionCmd transactionCmd = this.parser(rpcCmd);
                    String action = transactionCmd.getMsg().getAction();
                    RpcExecuteService rpcExecuteService = this.rpcBeanHelper.loadManagerService(transactionCmd.getType());
                    MessageDto messageDto = null;
                    try {
                        Serializable message = rpcExecuteService.execute(transactionCmd);
                        messageDto = MessageCreator.okResponse(message, action);
                    }
                    catch (Throwable e) {
                        log.error("rpc execute service error. action: " + action, e);
                        messageDto = MessageCreator.failResponse(e, action);
                    }
                    finally {
                        if (rpcCmd.getKey() != null) {
                            assert (Objects.nonNull(messageDto));
                            try {
                                messageDto.setGroupId(rpcCmd.getMsg().getGroupId());
                                rpcCmd.setMsg(messageDto);
                                this.rpcClient.send(rpcCmd);
                            }
                            catch (RpcException message) {}
                        }
                    }
                }
                catch (Throwable e) {
                    if (rpcCmd.getKey() == null) break block17;
                    log.info("send response.");
                    String action = rpcCmd.getMsg().getAction();
                    rpcCmd.setMsg(MessageCreator.serverException(action));
                    try {
                        this.rpcClient.send(rpcCmd);
                        log.info("send response ok.");
                    }
                    catch (RpcException ignored) {
                        log.error("requester:{} dead.", (Object)rpcCmd.getRemoteKey());
                    }
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
        this.executorService.awaitTermination(6L, TimeUnit.SECONDS);
    }

    private TransactionCmd parser(RpcCmd rpcCmd) {
        TransactionCmd cmd = new TransactionCmd();
        cmd.setRequestKey(rpcCmd.getKey());
        cmd.setRemoteKey(rpcCmd.getRemoteKey());
        cmd.setType(LCNCmdType.parserCmd((String)rpcCmd.getMsg().getAction()));
        cmd.setGroupId(rpcCmd.getMsg().getGroupId());
        cmd.setMsg(rpcCmd.getMsg());
        return cmd;
    }
}

