/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tm.txmsg.transaction;

import com.codingapi.txlcn.common.exception.FastStorageException;
import com.codingapi.txlcn.common.exception.TxManagerException;
import com.codingapi.txlcn.tm.cluster.TMProperties;
import com.codingapi.txlcn.tm.core.storage.FastStorage;
import com.codingapi.txlcn.tm.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tm.txmsg.TransactionCmd;
import java.io.Serializable;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_query-tm-cluster")
public class QueryTMClusterExecuteService
implements RpcExecuteService {
    private static final Logger log = LoggerFactory.getLogger(QueryTMClusterExecuteService.class);
    private final FastStorage fastStorage;

    @Autowired
    public QueryTMClusterExecuteService(FastStorage fastStorage) {
        this.fastStorage = fastStorage;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxManagerException {
        try {
            HashSet<String> tmSet = new HashSet<String>();
            for (TMProperties props : this.fastStorage.findTMProperties()) {
                tmSet.add(props.getHost() + ":" + props.getTransactionPort());
            }
            log.info("Query TM cluster. {}", tmSet);
            return tmSet;
        }
        catch (FastStorageException e) {
            throw new TxManagerException((Throwable)e);
        }
    }
}

