/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class TermQuery
extends AbstractFtsQuery {
    private final String term;
    private String field;
    private int fuzziness;
    private int prefixLength;

    public TermQuery(String term) {
        this.term = term;
    }

    public TermQuery field(String fieldName) {
        this.field = fieldName;
        return this;
    }

    public TermQuery fuzziness(int fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public TermQuery prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    @Override
    public TermQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        input.put("term", this.term);
        if (this.field != null) {
            input.put("field", this.field);
        }
        if (this.fuzziness > 0) {
            input.put("fuzziness", this.fuzziness);
            if (this.prefixLength > 0) {
                input.put("prefix_length", this.prefixLength);
            }
        }
    }
}

