/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.client.auth.scope.Scope;
import com.coze.openapi.service.auth.Auth;
import com.coze.openapi.service.auth.JWTOAuthClient;
import java.util.Objects;
import lombok.NonNull;

public class JWTOAuth
extends Auth {
    private Integer ttl;
    private String sessionName;
    private Scope scope;
    @NonNull
    private JWTOAuthClient jwtClient;

    public JWTOAuth(JWTOAuthClient client) {
        Objects.requireNonNull(client, "client must not be null");
        this.jwtClient = client;
        this.ttl = client.getTtl();
    }

    @Override
    public String token() {
        if (!this.needRefresh()) {
            return this.accessToken;
        }
        OAuthToken resp = this.jwtClient.getAccessToken(this.ttl, this.scope, this.sessionName);
        this.accessToken = resp.getAccessToken();
        this.expiresIn = resp.getExpiresIn().intValue();
        return this.accessToken;
    }

    public static JWTOAuthBuilder builder() {
        return new JWTOAuthBuilder();
    }

    public JWTOAuth(Integer ttl, String sessionName, Scope scope, @NonNull JWTOAuthClient jwtClient) {
        if (jwtClient == null) {
            throw new NullPointerException("jwtClient is marked non-null but is null");
        }
        this.ttl = ttl;
        this.sessionName = sessionName;
        this.scope = scope;
        this.jwtClient = jwtClient;
    }

    public static class JWTOAuthBuilder {
        private Integer ttl;
        private String sessionName;
        private Scope scope;
        private JWTOAuthClient jwtClient;

        JWTOAuthBuilder() {
        }

        public JWTOAuthBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public JWTOAuthBuilder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public JWTOAuthBuilder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public JWTOAuthBuilder jwtClient(@NonNull JWTOAuthClient jwtClient) {
            if (jwtClient == null) {
                throw new NullPointerException("jwtClient is marked non-null but is null");
            }
            this.jwtClient = jwtClient;
            return this;
        }

        public JWTOAuth build() {
            return new JWTOAuth(this.ttl, this.sessionName, this.scope, this.jwtClient);
        }

        public String toString() {
            return "JWTOAuth.JWTOAuthBuilder(ttl=" + this.ttl + ", sessionName=" + this.sessionName + ", scope=" + this.scope + ", jwtClient=" + this.jwtClient + ")";
        }
    }
}

