/*
 * Decompiled with CFR 0.152.
 */
package com.cwbase.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.cwbase.logback.JSONEventLayout;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    JedisPool pool;
    JSONEventLayout layout = new JSONEventLayout();
    String host = "localhost";
    int port = 6379;
    String key = null;
    int timeout = 2000;
    String password = null;
    int database = 0;

    public RedisAppender() {
        try {
            this.setSourceHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        Jedis client = this.pool.getResource();
        try {
            String json = this.layout.doLayout(event);
            client.rpush(this.key, new String[]{json});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pool.returnBrokenResource(client);
            client = null;
        }
        finally {
            if (client != null) {
                this.pool.returnResource(client);
            }
        }
    }

    public String getSource() {
        return this.layout.getSource();
    }

    public void setSource(String source) {
        this.layout.setSource(source);
    }

    public String getSourceHost() {
        return this.layout.getSourceHost();
    }

    public void setSourceHost(String sourceHost) {
        this.layout.setSourceHost(sourceHost);
    }

    public String getSourcePath() {
        return this.layout.getSourcePath();
    }

    public void setSourcePath(String sourcePath) {
        this.layout.setSourcePath(sourcePath);
    }

    public String getTags() {
        if (this.layout.getTags() != null) {
            Iterator<String> i = this.layout.getTags().iterator();
            StringBuffer sb = new StringBuffer();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(',');
            }
            return sb.toString();
        }
        return null;
    }

    public void setTags(String tags) {
        if (tags != null) {
            String[] atags = tags.split(",");
            this.layout.setTags(Arrays.asList(atags));
        }
    }

    public String getType() {
        return this.layout.getType();
    }

    public void setType(String type) {
        this.layout.setType(type);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setMdc(boolean flag) {
        this.layout.setProperties(flag);
    }

    public boolean getMdc() {
        return this.layout.getProperties();
    }

    public void setLocation(boolean flag) {
        this.layout.setLocationInfo(flag);
    }

    public boolean getLocation() {
        return this.layout.getLocationInfo();
    }

    public void setCallerStackIndex(int index) {
        this.layout.setCallerStackIdx(index);
    }

    public int getCallerStackIndex() {
        return this.layout.getCallerStackIdx();
    }

    public void start() {
        super.start();
        this.pool = new JedisPool(new GenericObjectPoolConfig(), this.host, this.port, this.timeout, this.password, this.database);
    }

    public void stop() {
        super.stop();
        this.pool.destroy();
    }
}

