/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import java.util.Collection;
import java.util.Iterator;

public class ConvertUtil {
    public static boolean toBoolean(String string) {
        if (StringUtil.equals(string = StringUtil.trimToEmpty(string), "0")) {
            return false;
        }
        if (StringUtil.equals(string, "1")) {
            return true;
        }
        boolean bl = false;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (Exception exception) {
            DBError.throwRuntimeException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        }
        return bl;
    }

    public static int toInt(long l2) {
        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
    }

    public static Integer toInteger(String string, String string2, String string3) {
        if (StringUtil.isEmpty(string = StringUtil.substringBetween(string, string2, string3))) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long[] toLongArray(Collection collection) {
        long[] lArray = new long[collection.size()];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (n2 < lArray.length) {
            lArray[n2] = (Long)iterator.next();
            ++n2;
        }
        return lArray;
    }

    public static final int ASCIIBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        int n5 = n3 + n4;
        int n6 = n3;
        int n7 = n2;
        while (n6 < n5) {
            cArray[n6] = (char)(0xFF & byArray[n7]);
            ++n6;
            ++n7;
        }
        return n4;
    }

    public static final int JavaCharsToASCIIBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byArray[n3 + n5] = (byte)cArray[n2 + n5];
            ++n5;
        }
        return n4;
    }

    public static final byte[] StringToASCII(String string) {
        byte[] byArray = new byte[string.length()];
        byArray = string.getBytes();
        return byArray;
    }

    public static final String UnicodeBytesToString(byte[] byArray, int n2) {
        int n3 = n2 >>> 1;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = byArray[n5] << 8;
            cArray[n4] = (char)(n6 | byArray[n5 + 1] & 0xFF);
            n5 += 2;
            ++n4;
        }
        return new String(cArray);
    }
}

