/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.adapter;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.invocation.JdbcMethodInvocation;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Collection;

public class WrapperAdapter
implements Wrapper {
    private final Collection<JdbcMethodInvocation> jdbcMethodInvocations = new ArrayList<JdbcMethodInvocation>();

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(String.format("[%s] cannot be unwrapped as [%s]", this.getClass().getName(), iface.getName()));
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public final void recordMethodInvocation(Class<?> targetClass, String methodName, Class<?>[] argumentTypes, Object[] arguments) {
        try {
            this.jdbcMethodInvocations.add(new JdbcMethodInvocation(targetClass.getMethod(methodName, argumentTypes), arguments));
        }
        catch (NoSuchMethodException ex) {
            throw new ShardingJdbcException(ex);
        }
    }

    public final void replayMethodsInvocation(Object target) {
        for (JdbcMethodInvocation each : this.jdbcMethodInvocations) {
            each.invoke(target);
        }
    }

    protected void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        throw ex;
    }
}

