/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.create;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.sql.MySQLCreateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.sql.OracleCreateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql.sql.PostgreSQLCreateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver.sql.SQLServerCreateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.create.AbstractCreateParser;

public final class CreateParserFactory {
    public static AbstractCreateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLCreateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleCreateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerCreateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLCreateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private CreateParserFactory() {
    }
}

