/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.truncate;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.sql.MySQLTruncateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.sql.OracleTruncateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql.sql.PostgreSQLTruncateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver.sql.SQLServerTruncateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.truncate.AbstractTruncateParser;

public final class TruncateParserFactory {
    public static AbstractTruncateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLTruncateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleTruncateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerTruncateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLTruncateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private TruncateParserFactory() {
    }
}

