/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.spring.datasource;

import com.dexcoder.commons.utils.ClassUtils;
import com.dexcoder.commons.utils.RandomUtils;
import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.commons.utils.UUIDUtils;
import com.dexcoder.dal.spring.datasource.DataSourceContext;
import com.dexcoder.dal.spring.datasource.DynamicDataSourceHolder;
import com.dexcoder.dal.spring.datasource.DynamicDataSourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicDataSource
extends AbstractRoutingDataSource {
    public static final String ATTR_ID = "id";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_DEFAULT = "default";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String DS_WEIGHT = "weight";
    public static final String DS_MODE = "mode";
    public static final String DS_MODE_R = "r";
    public static final String DS_MODE_W = "w";
    public static final String DS_MODE_RW = "rw";
    private static final Logger LOG = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final String DEFAULT_DS_CONFIG_FILE = "dynamic-ds.xml";
    private String dsConfigFile;
    private List<String> readDataSourceKeyList;
    private List<String> writeDataSourceKeyList;

    protected Object determineCurrentLookupKey() {
        DataSourceContext dsContent = DynamicDataSourceHolder.getDsContent();
        if (StrUtils.isNotBlank((String)dsContent.getDsKey())) {
            return dsContent.getDsKey();
        }
        if (dsContent.getIsWrite().booleanValue()) {
            String dsKey = this.writeDataSourceKeyList.get(RandomUtils.nextInt((int)this.writeDataSourceKeyList.size()));
            dsContent.setDsKey(dsKey);
        } else {
            String dsKey = this.readDataSourceKeyList.get(RandomUtils.nextInt((int)this.readDataSourceKeyList.size()));
            dsContent.setDsKey(dsKey);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5f53\u524d\u64cd\u4f5c\u4f7f\u7528\u6570\u636e\u6e90:{}", (Object)dsContent.getDsKey());
        }
        return dsContent.getDsKey();
    }

    public void afterPropertiesSet() {
        this.initDataSources();
    }

    public void initDataSources() {
        List<Map<String, String>> dataSourceList = DynamicDataSourceUtils.parseDataSources(this.getDsConfigFile());
        this.initDataSources(dataSourceList);
    }

    public void initDataSources(List<Map<String, String>> dataSourceList) {
        LOG.info("\u5f00\u59cb\u521d\u59cb\u5316\u52a8\u6001\u6570\u636e\u6e90");
        this.readDataSourceKeyList = new ArrayList<String>();
        this.writeDataSourceKeyList = new ArrayList<String>();
        HashMap<String, DataSource> targetDataSource = new HashMap<String, DataSource>();
        DataSource defaultTargetDataSource = null;
        for (Map<String, String> map : dataSourceList) {
            String dataSourceId = DynamicDataSourceUtils.getAndRemoveValue(map, ATTR_ID, UUIDUtils.getUUID8());
            String dataSourceClass = DynamicDataSourceUtils.getAndRemoveValue(map, ATTR_CLASS, null);
            String isDefaultDataSource = DynamicDataSourceUtils.getAndRemoveValue(map, ATTR_DEFAULT, "false");
            String weight = DynamicDataSourceUtils.getAndRemoveValue(map, DS_WEIGHT, "1");
            String mode = DynamicDataSourceUtils.getAndRemoveValue(map, DS_MODE, DS_MODE_RW);
            DataSource dataSource = (DataSource)ClassUtils.newInstance((String)dataSourceClass);
            DynamicDataSourceUtils.setDsProperties(map, dataSource);
            targetDataSource.put(dataSourceId, dataSource);
            if (Boolean.valueOf(isDefaultDataSource).booleanValue()) {
                defaultTargetDataSource = dataSource;
            }
            DynamicDataSourceUtils.addWeightDataSource(this.readDataSourceKeyList, this.writeDataSourceKeyList, dataSourceId, Integer.valueOf(weight), mode);
            LOG.info("dataSourceId={},dataSourceClass={},isDefaultDataSource={},weight={},mode={}", new Object[]{dataSourceId, dataSourceClass, isDefaultDataSource, weight, mode});
        }
        this.setTargetDataSources(targetDataSource);
        if (defaultTargetDataSource == null) {
            defaultTargetDataSource = (DataSource)(CollectionUtils.isEmpty(this.writeDataSourceKeyList) ? targetDataSource.get(this.readDataSourceKeyList.iterator().next()) : targetDataSource.get(this.writeDataSourceKeyList.iterator().next()));
        }
        this.setDefaultTargetDataSource(defaultTargetDataSource);
        super.afterPropertiesSet();
        LOG.info("\u521d\u59cb\u5316\u52a8\u6001\u6570\u636e\u6e90\u5b8c\u6210");
    }

    public String getDsConfigFile() {
        if (StrUtils.isBlank((String)this.dsConfigFile)) {
            return DEFAULT_DS_CONFIG_FILE;
        }
        return this.dsConfigFile;
    }

    public void setDsConfigFile(String dsConfigFile) {
        this.dsConfigFile = dsConfigFile;
    }
}

