/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.dal.BoundSql;
import com.dexcoder.dal.build.AutoFieldType;
import com.dexcoder.dal.build.DeleteBuilder;
import com.dexcoder.dal.build.InsertBuilder;
import com.dexcoder.dal.build.MetaTable;
import com.dexcoder.dal.build.SelectBuilder;
import com.dexcoder.dal.build.SqlBuilder;
import com.dexcoder.dal.build.UpdateBuilder;
import com.dexcoder.dal.handler.MappingHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criteria {
    private Class<?> entityClass;
    private SqlBuilder sqlBuilder;

    private Criteria(Class<?> clazz, SqlBuilder sqlBuilder) {
        this.entityClass = clazz;
        this.sqlBuilder = sqlBuilder;
    }

    public static Criteria select(Class<?> clazz) {
        return new Criteria(clazz, new SelectBuilder(clazz));
    }

    public static Criteria insert(Class<?> clazz) {
        return new Criteria(clazz, new InsertBuilder(clazz));
    }

    public static Criteria update(Class<?> clazz) {
        return new Criteria(clazz, new UpdateBuilder(clazz));
    }

    public static Criteria delete(Class<?> clazz) {
        return new Criteria(clazz, new DeleteBuilder(clazz));
    }

    public Criteria tableAlias(String alias) {
        new MetaTable.Builder(this.sqlBuilder.getMetaTable()).tableAlias(alias);
        return this;
    }

    public Criteria include(String ... field) {
        for (String f : field) {
            this.sqlBuilder.addField(f, null, null, AutoFieldType.INCLUDE, null);
        }
        return this;
    }

    public Criteria exclude(String ... field) {
        for (String f : field) {
            this.sqlBuilder.addField(f, null, null, AutoFieldType.EXCLUDE, null);
        }
        return this;
    }

    public Criteria asc(String ... field) {
        for (String f : field) {
            this.sqlBuilder.addField(f, null, "ASC", AutoFieldType.ORDER_BY_ASC, null);
        }
        return this;
    }

    public Criteria desc(String ... field) {
        for (String f : field) {
            this.sqlBuilder.addField(f, null, "DESC", AutoFieldType.ORDER_BY_DESC, null);
        }
        return this;
    }

    public Criteria into(String fieldName, Object value) {
        this.sqlBuilder.addField(fieldName, null, null, AutoFieldType.INSERT, value);
        return this;
    }

    public Criteria set(String fieldName, Object value) {
        this.sqlBuilder.addField(fieldName, null, null, AutoFieldType.UPDATE, value);
        return this;
    }

    public Criteria where(String fieldName, Object[] values) {
        this.where(fieldName, "=", values);
        return this;
    }

    public Criteria where(String fieldName, String fieldOperator, Object[] values) {
        this.sqlBuilder.addCondition(fieldName, null, fieldOperator, AutoFieldType.WHERE, values);
        return this;
    }

    public Criteria and(String fieldName, Object[] values) {
        this.and(fieldName, "=", values);
        return this;
    }

    public Criteria and(String fieldName, String fieldOperator, Object[] values) {
        this.sqlBuilder.addCondition(fieldName, "and", fieldOperator, AutoFieldType.WHERE, values);
        return this;
    }

    public Criteria or(String fieldName, Object[] values) {
        this.or(fieldName, "=", values);
        return this;
    }

    public Criteria or(String fieldName, String fieldOperator, Object[] values) {
        this.sqlBuilder.addCondition(fieldName, "or", fieldOperator, AutoFieldType.WHERE, values);
        return this;
    }

    public Criteria begin() {
        this.begin("and");
        return this;
    }

    public Criteria begin(String logicalOperator) {
        this.sqlBuilder.addCondition("(", logicalOperator, null, AutoFieldType.BRACKET_BEGIN, null);
        return this;
    }

    public Criteria end() {
        this.sqlBuilder.addCondition(")", null, null, AutoFieldType.BRACKET_END, null);
        return this;
    }

    public Criteria addSelectFunc(String func) {
        this.addSelectFunc(func, true, false);
        return this;
    }

    public Criteria addSelectFunc(String func, boolean isFieldExclusion, boolean isOrderBy) {
        this.sqlBuilder.addField(func, String.valueOf(isOrderBy), String.valueOf(isFieldExclusion), AutoFieldType.FUNC, null);
        return this;
    }

    public BoundSql build(Object entity, boolean isIgnoreNull, MappingHandler mappingHandler) {
        return this.sqlBuilder.build(entity, isIgnoreNull, mappingHandler);
    }

    public BoundSql build(boolean isIgnoreNull, MappingHandler mappingHandler) {
        return this.build(null, isIgnoreNull, mappingHandler);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getPkField(MappingHandler mappingHandler) {
        return this.sqlBuilder.getMetaTable().getPkFieldName(mappingHandler);
    }
}

