/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.dal.BoundSql;
import com.dexcoder.dal.build.AbstractSqlBuilder;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.build.AutoFieldType;
import com.dexcoder.dal.build.CriteriaBoundSql;
import com.dexcoder.dal.build.MetaTable;
import com.dexcoder.dal.exceptions.JdbcAssistantException;
import com.dexcoder.dal.handler.MappingHandler;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertBuilder
extends AbstractSqlBuilder {
    protected static final String COMMAND_OPEN = "INSERT INTO ";

    public InsertBuilder(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public void addField(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        AutoField autoField = new AutoField.Builder().name(fieldName).logicalOperator(logicalOperator).fieldOperator(fieldOperator).type(type).value(value).build();
        this.metaTable.getAutoFields().put(fieldName, autoField);
    }

    @Override
    public void addCondition(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        throw new JdbcAssistantException("InsertBuilder\u4e0d\u652f\u6301\u8bbe\u7f6e\u6761\u4ef6");
    }

    @Override
    public BoundSql build(Object entity, boolean isIgnoreNull, MappingHandler mappingHandler) {
        this.metaTable = new MetaTable.Builder(this.metaTable).entity(entity, isIgnoreNull).mappingHandler(mappingHandler).build();
        StringBuilder sql = new StringBuilder(COMMAND_OPEN);
        StringBuilder args = new StringBuilder("(");
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(this.metaTable.getTableAndAliasName()).append(" (");
        for (Map.Entry<String, AutoField> entry : this.metaTable.getAutoFields().entrySet()) {
            AutoField autoField = entry.getValue();
            if (autoField.getValue() == null && isIgnoreNull) continue;
            if (autoField.isNativeField()) {
                String nativeFieldName = this.tokenParse(autoField, this.metaTable);
                String nativeValue = this.tokenParse(String.valueOf(autoField.getValue()), this.metaTable);
                sql.append(nativeFieldName).append(",");
                args.append(nativeValue);
            } else {
                String columnName = this.metaTable.getColumnAndTableAliasName(autoField);
                sql.append(columnName).append(",");
                args.append("?");
            }
            args.append(",");
            params.add(autoField.getValue());
        }
        sql.deleteCharAt(sql.length() - 1);
        args.deleteCharAt(args.length() - 1);
        sql.append(")").append(" VALUES ").append((CharSequence)args.append(")"));
        return new CriteriaBoundSql(sql.toString(), params);
    }
}

