/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.build;

import com.dexcoder.commons.utils.ClassUtils;
import com.dexcoder.dal.BoundSql;
import com.dexcoder.dal.annotation.Column;
import com.dexcoder.dal.annotation.Transient;
import com.dexcoder.dal.build.AbstractSqlBuilder;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.build.AutoFieldType;
import com.dexcoder.dal.build.CriteriaBoundSql;
import com.dexcoder.dal.build.MetaTable;
import com.dexcoder.dal.build.OrderByBuilder;
import com.dexcoder.dal.build.SqlBuilder;
import com.dexcoder.dal.build.WhereBuilder;
import com.dexcoder.dal.exceptions.JdbcAssistantException;
import com.dexcoder.dal.handler.MappingHandler;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBuilder
extends AbstractSqlBuilder {
    protected static final String COMMAND_OPEN = "SELECT ";
    protected SqlBuilder whereBuilder;
    protected SqlBuilder orderByBuilder;

    public SelectBuilder(Class<?> clazz) {
        super(clazz);
        this.metaTable = new MetaTable.Builder(this.metaTable).initColumnAutoFields().initExcludeFields().initIncludeFields().initFuncAutoFields().build();
        this.whereBuilder = new WhereBuilder(clazz);
        this.orderByBuilder = new OrderByBuilder(clazz);
    }

    @Override
    public void addField(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        if (type == AutoFieldType.INCLUDE) {
            this.metaTable.getIncludeFields().add(fieldName);
        } else if (type == AutoFieldType.EXCLUDE) {
            this.metaTable.getExcludeFields().add(fieldName);
        } else if (type == AutoFieldType.ORDER_BY_ASC) {
            this.orderByBuilder.addField(fieldName, logicalOperator, "ASC", type, value);
        } else if (type == AutoFieldType.ORDER_BY_DESC) {
            this.orderByBuilder.addField(fieldName, logicalOperator, "DESC", type, value);
        } else if (type == AutoFieldType.FUNC) {
            new MetaTable.Builder(this.metaTable).isFieldExclusion(Boolean.valueOf(fieldOperator)).isOrderBy(Boolean.valueOf(logicalOperator));
            AutoField autoField = new AutoField.Builder().name(fieldName).logicalOperator(logicalOperator).fieldOperator(fieldOperator).type(type).value(value).build();
            this.metaTable.getFuncAutoFields().add(autoField);
        } else {
            throw new JdbcAssistantException("\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u8bbe\u7f6e\u7c7b\u578b");
        }
    }

    @Override
    public void addCondition(String fieldName, String logicalOperator, String fieldOperator, AutoFieldType type, Object value) {
        this.whereBuilder.addCondition(fieldName, logicalOperator, fieldOperator, type, value);
    }

    @Override
    public BoundSql build(Object entity, boolean isIgnoreNull, MappingHandler mappingHandler) {
        this.metaTable = new MetaTable.Builder(this.metaTable).mappingHandler(mappingHandler).build();
        new MetaTable.Builder(this.whereBuilder.getMetaTable()).tableAlias(this.metaTable.getTableAlias()).entity(entity, isIgnoreNull).mappingHandler(mappingHandler).build();
        String tableName = this.whereBuilder.getMetaTable().getTableAndAliasName();
        StringBuilder sb = new StringBuilder(COMMAND_OPEN);
        if (!this.metaTable.hasColumnFields() && !this.metaTable.isFieldExclusion()) {
            this.fetchClassFields(this.metaTable.getTableClass());
        }
        if (this.metaTable.hasFuncAutoField()) {
            for (AutoField autoField : this.metaTable.getFuncAutoFields()) {
                String nativeFieldName = this.tokenParse(autoField, this.metaTable);
                sb.append(nativeFieldName).append(",");
            }
        }
        if (!this.metaTable.isFieldExclusion()) {
            for (AutoField columnAutoField : this.metaTable.getColumnAutoFields()) {
                if (!this.metaTable.isIncludeField(columnAutoField.getName()) || this.metaTable.isExcludeField(columnAutoField.getName())) continue;
                String columnName = this.metaTable.getColumnAndTableAliasName(columnAutoField);
                sb.append(columnName);
                sb.append(",");
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" FROM ").append(tableName);
        BoundSql whereBoundSql = this.whereBuilder.build(entity, isIgnoreNull, mappingHandler);
        sb.append(whereBoundSql.getSql());
        if (this.metaTable.isOrderBy()) {
            new MetaTable.Builder(this.orderByBuilder.getMetaTable()).tableAlias(this.metaTable.getTableAlias()).build();
            BoundSql orderByBoundSql = this.orderByBuilder.build(entity, isIgnoreNull, mappingHandler);
            sb.append(orderByBoundSql.getSql());
        }
        return new CriteriaBoundSql(sb.toString(), whereBoundSql.getParameters());
    }

    protected void fetchClassFields(Class<?> clazz) {
        BeanInfo selfBeanInfo = ClassUtils.getSelfBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptors = selfBeanInfo.getPropertyDescriptors();
        ArrayList<AutoField> columnAutoFields = new ArrayList<AutoField>();
        for (PropertyDescriptor pd : propertyDescriptors) {
            Transient aTransient;
            Method readMethod = pd.getReadMethod();
            if (readMethod == null || (aTransient = readMethod.getAnnotation(Transient.class)) != null) continue;
            String fieldAnnotationName = null;
            Column aColumn = readMethod.getAnnotation(Column.class);
            if (aColumn != null) {
                fieldAnnotationName = aColumn.name();
            }
            AutoField autoField = new AutoField.Builder().name(pd.getName()).annotationName(fieldAnnotationName).build();
            columnAutoFields.add(autoField);
        }
        this.metaTable.getColumnAutoFields().addAll(columnAutoFields);
    }
}

