/*
 * Decompiled with CFR 0.152.
 */
package com.dexcoder.dal.handler;

import com.dexcoder.commons.utils.NameUtils;
import com.dexcoder.commons.utils.StrUtils;
import com.dexcoder.dal.build.AutoField;
import com.dexcoder.dal.handler.MappingHandler;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMappingHandler
implements MappingHandler {
    private static final String PRI_FIELD_SUFFIX = "Id";
    private static final String PRI_COLUMN_SUFFIX = "_ID";

    @Override
    public String getTableName(Class<?> entityClass, Map<String, AutoField> fieldMap) {
        return NameUtils.getUnderlineName((String)entityClass.getSimpleName());
    }

    @Override
    public String getPkFieldName(Class<?> entityClass) {
        String firstLowerName = NameUtils.getFirstLowerName((String)entityClass.getSimpleName());
        return firstLowerName + PRI_FIELD_SUFFIX;
    }

    @Override
    public String getPkColumnName(Class<?> entityClass) {
        String underlineName = NameUtils.getUnderlineName((String)entityClass.getSimpleName());
        return underlineName + PRI_COLUMN_SUFFIX;
    }

    @Override
    public String getColumnName(Class<?> entityClass, String fieldName) {
        String pkFieldName = this.getPkFieldName(entityClass);
        if (StrUtils.equals((String)pkFieldName, (String)fieldName)) {
            return this.getPkColumnName(entityClass);
        }
        return NameUtils.getUnderlineName((String)fieldName);
    }

    @Override
    public String getPkNativeValue(Class<?> entityClass, String dialect) {
        if (StrUtils.equalsIgnoreCase((String)dialect, (String)"oracle")) {
            String tableName = this.getTableName(entityClass, null);
            return String.format("SEQ_%s.NEXTVAL", tableName);
        }
        return null;
    }
}

