/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.metrics;

import android.content.Context;
import android.os.Build;
import com.dynatrace.agent.common.connectivity.NetworkConnectivityChecker;
import com.dynatrace.agent.common.connectivity.NetworkType;
import com.dynatrace.agent.di.MetricsUpdater;
import com.dynatrace.agent.events.enrichment.NetworkTypeExtensionsKt;
import com.dynatrace.agent.metrics.MetricsCache;
import com.dynatrace.agent.util.RootDetector;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012#\b\u0002\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/agent/metrics/MetricsUpdaterImpl;", "Lcom/dynatrace/agent/di/MetricsUpdater;", "networkConnectivityChecker", "Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;", "applicationContext", "Landroid/content/Context;", "isDeviceRooted", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "context", "", "<init>", "(Lcom/dynatrace/agent/common/connectivity/NetworkConnectivityChecker;Landroid/content/Context;Lkotlin/jvm/functions/Function1;)V", "updateStaticMetricsInCache", "", "cache", "Lcom/dynatrace/agent/metrics/MetricsCache;", "updateDynamicMetricsInCache", "com.dynatrace.agent_release"})
public final class MetricsUpdaterImpl
implements MetricsUpdater {
    @NotNull
    private final NetworkConnectivityChecker networkConnectivityChecker;
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Function1<Context, Boolean> isDeviceRooted;

    public MetricsUpdaterImpl(@NotNull NetworkConnectivityChecker networkConnectivityChecker, @NotNull Context applicationContext, @NotNull Function1<? super Context, Boolean> isDeviceRooted) {
        Intrinsics.checkNotNullParameter((Object)networkConnectivityChecker, (String)"networkConnectivityChecker");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(isDeviceRooted, (String)"isDeviceRooted");
        this.networkConnectivityChecker = networkConnectivityChecker;
        this.applicationContext = applicationContext;
        this.isDeviceRooted = isDeviceRooted;
    }

    public /* synthetic */ MetricsUpdaterImpl(NetworkConnectivityChecker networkConnectivityChecker, Context context, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = MetricsUpdaterImpl::_init_$lambda$0;
        }
        this(networkConnectivityChecker, context, (Function1<? super Context, Boolean>)function1);
    }

    @Override
    public void updateStaticMetricsInCache(@NotNull MetricsCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        boolean rooted = (Boolean)this.isDeviceRooted.invoke((Object)this.applicationContext);
        cache.setDeviceIsRooted(rooted);
        cache.setBundle(this.applicationContext.getPackageName());
        cache.setDeviceManufacturer(Build.MANUFACTURER);
        cache.setDeviceModelIdentifier(Build.MODEL);
        cache.setOsName("Android");
        cache.setOsVersion(Build.VERSION.RELEASE);
    }

    @Override
    public void updateDynamicMetricsInCache(@NotNull MetricsCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        NetworkType networkType = this.networkConnectivityChecker.getNetworkType();
        String mappedValue = NetworkTypeExtensionsKt.getStringRepresentation(networkType);
        cache.setNetworkType(mappedValue);
        int orientation = this.applicationContext.getResources().getConfiguration().orientation;
        cache.setDeviceOrientation(orientation);
    }

    private static final boolean _init_$lambda$0(Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RootDetector.INSTANCE.isDeviceRooted(it);
    }
}

