/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.SelfMonitoringSegment;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class SelfMonitoring {
    private static final String TAG = Global.LOG_PREFIX + "SelfMonitoring";

    public static void reportLogEvent(String eventName, String eventPayload) {
        if (eventName == null || eventName.isEmpty()) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        AdkSettings adkSettings = AdkSettings.getInstance();
        if (!adkSettings.getServerConfiguration().isSelfmonitoring()) {
            return;
        }
        if (adkSettings.getConfiguration().mode == AgentMode.APP_MON) {
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        if (session.isSelfMonitoringLimitReached()) {
            return;
        }
        int serverId = adkSettings.serverId;
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("Handle self monitoring event name=\"" + eventName + "\" payload=\"" + eventPayload + "\""));
        }
        SelfMonitoringSegment selfMonitoringSegment = new SelfMonitoringSegment(eventName, eventPayload, session, serverId);
        Core.getCalloutTable().addOtherEvent();
        Core.saveSegment(selfMonitoringSegment);
        session.addSelfMonitoringEvent();
    }
}

