/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.recyclerview.callback;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.dynatrace.android.internal.api.recyclerview.interceptor.RecyclerViewReloadInterceptor;
import com.dynatrace.android.internal.api.recyclerview.interceptor.RecyclerViewScrollInterceptor;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.TrackingManager;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.utils.Debouncer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/internal/api/recyclerview/callback/RecyclerViewCallback;", "", "<init>", "()V", "DELAY_MS", "", "debouncer", "Lcom/dynatrace/android/sessionreplay/tracking/utils/Debouncer;", "scrollInterceptor", "Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewScrollInterceptor;", "tableReloadInterceptor", "Lcom/dynatrace/android/internal/api/recyclerview/interceptor/RecyclerViewReloadInterceptor;", "addOnScrollListener", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "setAdapter", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "api.androidx_release"})
public final class RecyclerViewCallback {
    @NotNull
    public static final RecyclerViewCallback INSTANCE = new RecyclerViewCallback();
    private static final long DELAY_MS = 100L;
    @NotNull
    private static final Debouncer debouncer = new Debouncer(null, 1, null);
    @NotNull
    private static final RecyclerViewScrollInterceptor scrollInterceptor = new RecyclerViewScrollInterceptor((Function3<? super View, ? super Integer, ? super Integer, Unit>)((Function3)RecyclerViewCallback::scrollInterceptor$lambda$0));
    @NotNull
    private static final RecyclerViewReloadInterceptor tableReloadInterceptor = new RecyclerViewReloadInterceptor((Function1<? super View, Unit>)((Function1)RecyclerViewCallback::tableReloadInterceptor$lambda$2));

    private RecyclerViewCallback() {
    }

    @JvmStatic
    public static final void addOnScrollListener(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        DTLogger.INSTANCE.tracking("Intercepting RecyclerView scroll: " + recyclerView);
        scrollInterceptor.intercept(recyclerView);
    }

    @JvmStatic
    public static final void setAdapter(@NotNull RecyclerView recyclerView, @Nullable RecyclerView.Adapter<?> adapter) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (adapter != null) {
            DTLogger.INSTANCE.tracking("Intercepting RecyclerView reload: " + recyclerView);
            tableReloadInterceptor.intercept(recyclerView, adapter);
        }
    }

    private static final Unit scrollInterceptor$lambda$0(View view, int dx, int dy) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        TrackingManager.INSTANCE.getTrackingApi().trackScroll((UIContainer)new UIView(view, null, null, 6, null), dx, dy);
        return Unit.INSTANCE;
    }

    private static final Unit tableReloadInterceptor$lambda$2$lambda$1(View $view) {
        TrackingManager.INSTANCE.getTrackingApi().trackTableReload((UIContainer)new UIView($view, null, null, 6, null));
        return Unit.INSTANCE;
    }

    private static final Unit tableReloadInterceptor$lambda$2(View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        debouncer.debounce(100L, () -> RecyclerViewCallback.tableReloadInterceptor$lambda$2$lambda$1(view));
        return Unit.INSTANCE;
    }
}

