/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.daos.sql;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.dynatrace.android.sessionreplay.data.daos.CheckpointDAO;
import com.dynatrace.android.sessionreplay.data.daos.EventDAO;
import com.dynatrace.android.sessionreplay.data.daos.sql.BaseSqlDAO;
import com.dynatrace.android.sessionreplay.data.mappers.Mapper;
import com.dynatrace.android.sessionreplay.model.Checkpoint;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.GestureEvent;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001'B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\"\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J*\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J(\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\"\u001a\u00020!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\bH\u0014J\u001a\u0010&\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/SQLEventDAO;", "Lcom/dynatrace/android/sessionreplay/data/daos/sql/BaseSqlDAO;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Lcom/dynatrace/android/sessionreplay/data/daos/EventDAO;", "db", "Landroid/database/sqlite/SQLiteDatabase;", "toEventMapper", "Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;", "Landroid/database/Cursor;", "fromEventMapper", "Landroid/content/ContentValues;", "checkpointDAO", "Lcom/dynatrace/android/sessionreplay/data/daos/CheckpointDAO;", "<init>", "(Landroid/database/sqlite/SQLiteDatabase;Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;Lcom/dynatrace/android/sessionreplay/data/mappers/Mapper;Lcom/dynatrace/android/sessionreplay/data/daos/CheckpointDAO;)V", "get", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "id", "", "getAll", "", "getByVisitId", "visitId", "getBetweenSystemTimes", "systemStartTime", "", "systemEndTime", "create", "event", "update", "events", "delete", "", "deleteAll", "eventsIds", "map", "cursor", "createContentValues", "Companion", "datalayer_release"})
@SourceDebugExtension(value={"SMAP\nSQLEventDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLEventDAO.kt\ncom/dynatrace/android/sessionreplay/data/daos/sql/SQLEventDAO\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n1863#2,2:124\n1863#2,2:126\n1863#2,2:130\n37#3,2:128\n*S KotlinDebug\n*F\n+ 1 SQLEventDAO.kt\ncom/dynatrace/android/sessionreplay/data/daos/sql/SQLEventDAO\n*L\n58#1:124,2\n71#1:126,2\n105#1:130,2\n98#1:128,2\n*E\n"})
public final class SQLEventDAO
extends BaseSqlDAO<Event>
implements EventDAO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Mapper<Cursor, Event> toEventMapper;
    @NotNull
    private final Mapper<Event, ContentValues> fromEventMapper;
    @NotNull
    private final CheckpointDAO checkpointDAO;
    @NotNull
    private static final String TABLE = "event";

    public SQLEventDAO(@NotNull SQLiteDatabase db, @NotNull Mapper<Cursor, Event> toEventMapper, @NotNull Mapper<Event, ContentValues> fromEventMapper, @NotNull CheckpointDAO checkpointDAO) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(toEventMapper, (String)"toEventMapper");
        Intrinsics.checkNotNullParameter(fromEventMapper, (String)"fromEventMapper");
        Intrinsics.checkNotNullParameter((Object)checkpointDAO, (String)"checkpointDAO");
        super(db, TABLE);
        this.toEventMapper = toEventMapper;
        this.fromEventMapper = fromEventMapper;
        this.checkpointDAO = checkpointDAO;
    }

    @Override
    @NotNull
    public Result<Event, DataError> get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Event event = (Event)this.get("_id", id);
        return event != null ? (Result)new Result.Success((Object)event) : (Result)new Result.Error((Object)DataError.NotFound.INSTANCE);
    }

    @Override
    @NotNull
    public Result<List<Event>, DataError> getAll() {
        return (Result)new Result.Success(this.getAllRecords());
    }

    @Override
    @NotNull
    public Result<List<Event>, DataError> getByVisitId(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        return (Result)new Result.Success(this.getByAttribute("visit_id", visitId, "start_time DESC"));
    }

    @Override
    @NotNull
    public Result<List<Event>, DataError> getBetweenSystemTimes(long systemStartTime, long systemEndTime) {
        return (Result)new Result.Success(this.getByRange("system_time", String.valueOf(systemStartTime), String.valueOf(systemEndTime), "system_time DESC"));
    }

    @Override
    @NotNull
    public Result<Event, DataError> create(@NotNull Event event, @NotNull String visitId) {
        Result<Event, DataError> result;
        Intrinsics.checkNotNullParameter((Object)event, (String)TABLE);
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        try {
            this.getDb().insertOrThrow(TABLE, null, this.createContentValues(event, visitId));
            if (event instanceof GestureEvent) {
                Iterable $this$forEach$iv = ((GestureEvent)event).getCheckpoints();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Checkpoint it = (Checkpoint)element$iv;
                    boolean bl = false;
                    this.checkpointDAO.create(it, event.getId());
                }
            }
            result = this.get(event.getId());
        }
        catch (SQLException e) {
            result = (Result<Event, DataError>)new Result.Error((Object)new DataError.SaveError((Throwable)e));
        }
        return result;
    }

    @Override
    @NotNull
    public Result<List<Event>, DataError> update(@NotNull List<? extends Event> events) {
        Result result;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        try {
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Event it = (Event)element$iv;
                boolean bl = false;
                String[] stringArray = new String[]{it.getId()};
                this.getDb().update(TABLE, this.createContentValues(it, null), "_id = ?", stringArray);
            }
            result = (Result)new Result.Success(events);
        }
        catch (SQLException e) {
            result = (Result)new Result.Error((Object)new DataError.SaveError((Throwable)e));
        }
        return result;
    }

    @Override
    public void delete(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.delete("_id", id);
    }

    @Override
    public void deleteAll(@NotNull List<String> eventsIds) {
        Intrinsics.checkNotNullParameter(eventsIds, (String)"eventsIds");
        if (((Collection)eventsIds).isEmpty()) {
            return;
        }
        String args = "";
        List whereArgs = new ArrayList();
        for (String eventId : eventsIds) {
            whereArgs.add(eventId);
            args = args + " ?,";
        }
        args = StringsKt.removeSuffix((String)args, (CharSequence)",");
        String where = "_id IN (" + args + ')';
        Collection $this$toTypedArray$iv = whereArgs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.deleteAllRecords(where, thisCollection$iv.toArray(new String[0]));
    }

    @Override
    @NotNull
    protected Event map(@NotNull Cursor cursor) {
        Event event;
        block2: {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            event = this.toEventMapper.map(cursor);
            if (!(event instanceof GestureEvent)) break block2;
            List list = (List)this.checkpointDAO.getByEventId(event.getId()).getOrNull();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Checkpoint it = (Checkpoint)element$iv;
                    boolean bl = false;
                    ((GestureEvent)event).addCheckpoint(it);
                }
            }
        }
        return event;
    }

    private final ContentValues createContentValues(Event event, String visitId) {
        ContentValues eventValues = this.fromEventMapper.map(event);
        if (visitId != null) {
            eventValues.put("visit_id", visitId);
        }
        return eventValues;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/sql/SQLEventDAO$Companion;", "", "<init>", "()V", "TABLE", "", "datalayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

