/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import com.dynatrace.android.sessionreplay.tracking.observer.ScreenObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.utils.ViewExtensionKt;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/DisplayViewTracker;", "", "screenObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/ScreenObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/ScreenObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "trackDisplayView", "", "uiContainer", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIContainer;", "trackinglayer_release"})
public final class DisplayViewTracker {
    @Nullable
    private final ScreenObserver screenObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public DisplayViewTracker(@Nullable ScreenObserver screenObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.screenObserver = screenObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackDisplayView(@NotNull UIContainer uiContainer) {
        block3: {
            View view;
            Object object;
            Intrinsics.checkNotNullParameter((Object)uiContainer, (String)"uiContainer");
            if (this.screenObserver == null) {
                return;
            }
            Date date = new Date();
            if (uiContainer instanceof UIComposeView) {
                View view2 = uiContainer.getView$trackinglayer_release();
                object = view2 != null ? ViewExtensionKt.findDecorView(view2) : null;
            } else {
                object = uiContainer.getContainerView();
            }
            View view3 = view = object;
            if (view3 == null) break block3;
            View it = view3;
            boolean bl = false;
            view.post(() -> DisplayViewTracker.trackDisplayView$lambda$2$lambda$1(this, uiContainer, date, view));
        }
    }

    private static final Unit trackDisplayView$lambda$2$lambda$1$lambda$0(DisplayViewTracker this$0, Date $date, View $view, Bitmap bitmap) {
        this$0.screenObserver.onDisplay($date, ViewExtensionsKt.getMetadata($view), this$0.maskingValidator.validate($view), bitmap);
        return Unit.INSTANCE;
    }

    private static final void trackDisplayView$lambda$2$lambda$1(DisplayViewTracker this$0, UIContainer $uiContainer, Date $date, View $view) {
        this$0.screenshotHandler.takeScreenshot($uiContainer, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> DisplayViewTracker.trackDisplayView$lambda$2$lambda$1$lambda$0(this$0, $date, $view, arg_0)));
    }
}

