/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.Log;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.MemoryChunkUtil;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;
import java.io.Closeable;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

@DoNotStrip
public class NativeMemoryChunk
implements MemoryChunk,
Closeable {
    private static final String TAG = "NativeMemoryChunk";
    private final long mNativePtr;
    private final int mSize;
    private boolean mIsClosed;

    public NativeMemoryChunk(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        this.mSize = size;
        this.mNativePtr = NativeMemoryChunk.nativeAllocate(this.mSize);
        this.mIsClosed = false;
    }

    @VisibleForTesting
    public NativeMemoryChunk() {
        this.mSize = 0;
        this.mNativePtr = 0L;
        this.mIsClosed = true;
    }

    @Override
    public synchronized void close() {
        if (!this.mIsClosed) {
            this.mIsClosed = true;
            NativeMemoryChunk.nativeFree(this.mNativePtr);
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mIsClosed;
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    @Override
    public synchronized int write(int memoryOffset, byte[] byteArray, int byteArrayOffset, int count) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        int actualCount = MemoryChunkUtil.adjustByteCount(memoryOffset, count, this.mSize);
        MemoryChunkUtil.checkBounds(memoryOffset, byteArray.length, byteArrayOffset, actualCount, this.mSize);
        NativeMemoryChunk.nativeCopyFromByteArray(this.mNativePtr + (long)memoryOffset, byteArray, byteArrayOffset, actualCount);
        return actualCount;
    }

    @Override
    public synchronized int read(int memoryOffset, byte[] byteArray, int byteArrayOffset, int count) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        int actualCount = MemoryChunkUtil.adjustByteCount(memoryOffset, count, this.mSize);
        MemoryChunkUtil.checkBounds(memoryOffset, byteArray.length, byteArrayOffset, actualCount, this.mSize);
        NativeMemoryChunk.nativeCopyToByteArray(this.mNativePtr + (long)memoryOffset, byteArray, byteArrayOffset, actualCount);
        return actualCount;
    }

    @Override
    public synchronized byte read(int offset) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset < this.mSize ? 1 : 0) != 0);
        return NativeMemoryChunk.nativeReadByte(this.mNativePtr + (long)offset);
    }

    @Override
    public long getNativePtr() {
        return this.mNativePtr;
    }

    @Override
    @Nullable
    public ByteBuffer getByteBuffer() {
        return null;
    }

    @Override
    public long getUniqueId() {
        return this.mNativePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(int offset, MemoryChunk other, int otherOffset, int count) {
        Preconditions.checkNotNull((Object)other);
        if (other.getUniqueId() == this.getUniqueId()) {
            Log.w((String)TAG, (String)("Copying from NativeMemoryChunk " + Integer.toHexString(System.identityHashCode(this)) + " to NativeMemoryChunk " + Integer.toHexString(System.identityHashCode(other)) + " which share the same address " + Long.toHexString(this.mNativePtr)));
            Preconditions.checkArgument((boolean)false);
        }
        if (other.getUniqueId() < this.getUniqueId()) {
            MemoryChunk memoryChunk = other;
            synchronized (memoryChunk) {
                NativeMemoryChunk nativeMemoryChunk = this;
                synchronized (nativeMemoryChunk) {
                    this.doCopy(offset, other, otherOffset, count);
                }
            }
            return;
        }
        NativeMemoryChunk nativeMemoryChunk = this;
        synchronized (nativeMemoryChunk) {
            MemoryChunk memoryChunk = other;
            synchronized (memoryChunk) {
                this.doCopy(offset, other, otherOffset, count);
            }
        }
    }

    private void doCopy(int offset, MemoryChunk other, int otherOffset, int count) {
        if (!(other instanceof NativeMemoryChunk)) {
            throw new IllegalArgumentException("Cannot copy two incompatible MemoryChunks");
        }
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkState((!other.isClosed() ? 1 : 0) != 0);
        MemoryChunkUtil.checkBounds(offset, other.getSize(), otherOffset, count, this.mSize);
        NativeMemoryChunk.nativeMemcpy(other.getNativePtr() + (long)otherOffset, this.mNativePtr + (long)offset, count);
    }

    protected void finalize() throws Throwable {
        if (this.isClosed()) {
            return;
        }
        Log.w((String)TAG, (String)("finalize: Chunk " + Integer.toHexString(System.identityHashCode(this)) + " still active. "));
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @DoNotStrip
    private static native long nativeAllocate(int var0);

    @DoNotStrip
    private static native void nativeFree(long var0);

    @DoNotStrip
    private static native void nativeCopyToByteArray(long var0, byte[] var2, int var3, int var4);

    @DoNotStrip
    private static native void nativeCopyFromByteArray(long var0, byte[] var2, int var3, int var4);

    @DoNotStrip
    private static native void nativeMemcpy(long var0, long var2, int var4);

    @DoNotStrip
    private static native byte nativeReadByte(long var0);

    static {
        ImagePipelineNativeLoader.load();
    }
}

