/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.producers.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class BaseConsumer<T>
implements Consumer<T> {
    private boolean mIsFinished = false;

    public static boolean isLast(int status) {
        return (status & 1) == 1;
    }

    public static boolean isNotLast(int status) {
        return !BaseConsumer.isLast(status);
    }

    public static int turnOnStatusFlag(int status, int flag) {
        return status | flag;
    }

    public static int turnOffStatusFlag(int status, int flag) {
        return status & ~flag;
    }

    public static boolean statusHasFlag(int status, int flag) {
        return (status & flag) == flag;
    }

    public static boolean statusHasAnyFlag(int status, int flag) {
        return (status & flag) != 0;
    }

    public static int simpleStatusForIsLast(boolean isLast) {
        return isLast ? 1 : 0;
    }

    @Override
    public synchronized void onNewResult(@Nullable T newResult, int status) {
        if (this.mIsFinished) {
            return;
        }
        this.mIsFinished = BaseConsumer.isLast(status);
        try {
            this.onNewResultImpl(newResult, status);
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    @Override
    public synchronized void onFailure(Throwable t) {
        if (this.mIsFinished) {
            return;
        }
        this.mIsFinished = true;
        try {
            this.onFailureImpl(t);
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    @Override
    public synchronized void onCancellation() {
        if (this.mIsFinished) {
            return;
        }
        this.mIsFinished = true;
        try {
            this.onCancellationImpl();
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    @Override
    public synchronized void onProgressUpdate(float progress) {
        if (this.mIsFinished) {
            return;
        }
        try {
            this.onProgressUpdateImpl(progress);
        }
        catch (Exception e) {
            this.onUnhandledException(e);
        }
    }

    protected abstract void onNewResultImpl(T var1, int var2);

    protected abstract void onFailureImpl(Throwable var1);

    protected abstract void onCancellationImpl();

    protected void onProgressUpdateImpl(float progress) {
    }

    protected void onUnhandledException(Exception e) {
        FLog.wtf(this.getClass(), (String)"unhandled exception", (Throwable)e);
    }
}

