/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.listener;

import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.listener.RequestListener2;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class ForwardingRequestListener2
implements RequestListener2 {
    private static final String TAG = "ForwardingRequestListener2";
    private final List<RequestListener2> mRequestListeners;

    public ForwardingRequestListener2(Set<RequestListener2> requestListeners) {
        this.mRequestListeners = new ArrayList<RequestListener2>(requestListeners.size());
        for (RequestListener2 requestListener : requestListeners) {
            if (requestListener == null) continue;
            this.mRequestListeners.add(requestListener);
        }
    }

    public ForwardingRequestListener2(RequestListener2 ... requestListeners) {
        this.mRequestListeners = new ArrayList<RequestListener2>(requestListeners.length);
        for (RequestListener2 requestListener : requestListeners) {
            if (requestListener == null) continue;
            this.mRequestListeners.add(requestListener);
        }
    }

    public void addRequestListener(RequestListener2 requestListener) {
        this.mRequestListeners.add(requestListener);
    }

    @Override
    public void onRequestStart(ProducerContext producerContext) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestStart(producerContext);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestStart", exception);
            }
        }
    }

    @Override
    public void onProducerStart(ProducerContext producerContext, String producerName) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerStart(producerContext, producerName);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerStart", exception);
            }
        }
    }

    @Override
    public void onProducerFinishWithSuccess(ProducerContext producerContext, String producerName, @Nullable Map<String, String> extraMap) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerFinishWithSuccess(producerContext, producerName, extraMap);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithSuccess", exception);
            }
        }
    }

    @Override
    public void onProducerFinishWithFailure(ProducerContext producerContext, String producerName, Throwable t, @Nullable Map<String, String> extraMap) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerFinishWithFailure(producerContext, producerName, t, extraMap);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithFailure", exception);
            }
        }
    }

    @Override
    public void onProducerFinishWithCancellation(ProducerContext producerContext, String producerName, @Nullable Map<String, String> extraMap) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerFinishWithCancellation(producerContext, producerName, extraMap);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithCancellation", exception);
            }
        }
    }

    @Override
    public void onProducerEvent(ProducerContext producerContext, String producerName, String producerEventName) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onProducerEvent(producerContext, producerName, producerEventName);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onIntermediateChunkStart", exception);
            }
        }
    }

    @Override
    public void onUltimateProducerReached(ProducerContext producerContext, String producerName, boolean successful) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onUltimateProducerReached(producerContext, producerName, successful);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onProducerFinishWithSuccess", exception);
            }
        }
    }

    @Override
    public void onRequestSuccess(ProducerContext producerContext) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestSuccess(producerContext);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestSuccess", exception);
            }
        }
    }

    @Override
    public void onRequestFailure(ProducerContext producerContext, Throwable throwable) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestFailure(producerContext, throwable);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestFailure", exception);
            }
        }
    }

    @Override
    public void onRequestCancellation(ProducerContext producerContext) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            RequestListener2 listener = this.mRequestListeners.get(i);
            try {
                listener.onRequestCancellation(producerContext);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRequestCancellation", exception);
            }
        }
    }

    @Override
    public boolean requiresExtraMap(ProducerContext producerContext, String producerName) {
        int numberOfListeners = this.mRequestListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            if (!this.mRequestListeners.get(i).requiresExtraMap(producerContext, producerName)) continue;
            return true;
        }
        return false;
    }

    private void onException(String message, Throwable t) {
        FLog.e((String)TAG, (String)message, (Throwable)t);
    }
}

