/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.imagepipeline.memory.BitmapCounterConfig;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class BitmapCounterProvider {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    public static final int MAX_BITMAP_TOTAL_SIZE = BitmapCounterProvider.getMaxSizeHardCap();
    private static int sMaxBitmapCount = 384;
    private static volatile BitmapCounter sBitmapCounter;

    private static int getMaxSizeHardCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        if ((long)maxMemory > 0x1000000L) {
            return maxMemory / 4 * 3;
        }
        return maxMemory / 2;
    }

    public static void initialize(BitmapCounterConfig bitmapCounterConfig) {
        if (sBitmapCounter != null) {
            throw new IllegalStateException("BitmapCounter has already been created! `BitmapCounterProvider.initialize(...)` should only be called before `BitmapCounterProvider.get()` or not at all!");
        }
        sMaxBitmapCount = bitmapCounterConfig.getMaxBitmapCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ThreadSafe
    public static BitmapCounter get() {
        if (sBitmapCounter != null) return sBitmapCounter;
        Class<BitmapCounterProvider> clazz = BitmapCounterProvider.class;
        synchronized (BitmapCounterProvider.class) {
            if (sBitmapCounter != null) return sBitmapCounter;
            sBitmapCounter = new BitmapCounter(sMaxBitmapCount, MAX_BITMAP_TOTAL_SIZE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sBitmapCounter;
        }
    }
}

