/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.postprocessors;

import android.content.Context;
import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.filter.IterativeBoxBlurFilter;
import com.facebook.imagepipeline.filter.RenderScriptBlurFilter;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Locale;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class BlurPostProcessor
extends BasePostprocessor {
    private static final boolean canUseRenderScript = RenderScriptBlurFilter.canUseRenderScript();
    private static final int DEFAULT_ITERATIONS = 3;
    private final int mIterations;
    private final Context mContext;
    private final int mBlurRadius;
    @Nullable
    private CacheKey mCacheKey;

    public BlurPostProcessor(int blurRadius, Context context, int iterations) {
        Preconditions.checkArgument((Boolean)(blurRadius > 0 && blurRadius <= 25 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(iterations > 0 ? 1 : 0));
        Preconditions.checkNotNull((Object)context);
        this.mIterations = iterations;
        this.mBlurRadius = blurRadius;
        this.mContext = context;
    }

    public BlurPostProcessor(int blurRadius, Context context) {
        this(blurRadius, context, 3);
    }

    @Override
    public void process(Bitmap destBitmap, Bitmap sourceBitmap) {
        if (canUseRenderScript) {
            RenderScriptBlurFilter.blurBitmap(destBitmap, sourceBitmap, this.mContext, this.mBlurRadius);
        } else {
            super.process(destBitmap, sourceBitmap);
        }
    }

    @Override
    public void process(Bitmap bitmap) {
        IterativeBoxBlurFilter.boxBlurBitmapInPlace(bitmap, this.mIterations, this.mBlurRadius);
    }

    @Override
    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        if (this.mCacheKey == null) {
            String key = canUseRenderScript ? String.format((Locale)null, "IntrinsicBlur;%d", this.mBlurRadius) : String.format((Locale)null, "IterativeBoxBlur;%d;%d", this.mIterations, this.mBlurRadius);
            this.mCacheKey = new SimpleCacheKey(key);
        }
        return this.mCacheKey;
    }
}

