/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.stetho.rhino;

import android.support.annotation.NonNull;
import android.util.Log;
import com.facebook.stetho.common.LogUtil;
import com.facebook.stetho.inspector.console.CLog;
import com.facebook.stetho.inspector.console.RuntimeRepl;
import com.facebook.stetho.inspector.console.RuntimeReplFactory;
import com.facebook.stetho.inspector.protocol.module.Console;
import com.facebook.stetho.rhino.JsConsole;
import com.facebook.stetho.rhino.JsRuntimeRepl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class JsRuntimeReplFactoryBuilder {
    private static final String SOURCE_NAME = "chrome";
    private final android.content.Context mContext;
    private final Set<Class<?>> mClasses = new HashSet();
    private final Set<String> mPackages = new HashSet<String>();
    private final Map<String, Object> mVariables = new HashMap<String, Object>();
    private final Map<String, Function> mFunctions = new HashMap<String, Function>();

    public static RuntimeReplFactory defaultFactory(@NonNull android.content.Context context) {
        return new JsRuntimeReplFactoryBuilder(context).build();
    }

    public JsRuntimeReplFactoryBuilder(@NonNull android.content.Context context) {
        this.mContext = context;
        this.mPackages.add(context.getPackageName());
        this.mVariables.put("$_", Context.getUndefinedValue());
    }

    @NonNull
    public JsRuntimeReplFactoryBuilder importClass(@NonNull Class<?> aClass) {
        this.mClasses.add(aClass);
        return this;
    }

    @NonNull
    public JsRuntimeReplFactoryBuilder importPackage(@NonNull String packageName) {
        this.mPackages.add(packageName);
        return this;
    }

    public JsRuntimeReplFactoryBuilder addVariable(@NonNull String name, Object value) {
        this.mVariables.put(name, value);
        return this;
    }

    @NonNull
    public JsRuntimeReplFactoryBuilder addFunction(@NonNull String name, @NonNull Function function) {
        this.mFunctions.put(name, function);
        return this;
    }

    public RuntimeReplFactory build() {
        return new RuntimeReplFactory(){

            public RuntimeRepl newInstance() {
                return new JsRuntimeRepl(JsRuntimeReplFactoryBuilder.this.initJsScope());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ScriptableObject initJsScope() {
        Context jsContext = JsRuntimeRepl.enterJsContext();
        try {
            ScriptableObject scope;
            ScriptableObject scriptableObject = scope = this.initJsScope(jsContext);
            return scriptableObject;
        }
        finally {
            Context.exit();
        }
    }

    @NonNull
    private ScriptableObject initJsScope(@NonNull Context jsContext) {
        ImporterTopLevel importerTopLevel = new ImporterTopLevel(jsContext);
        ScriptableObject scope = jsContext.initStandardObjects((ScriptableObject)importerTopLevel, false);
        ScriptableObject.putProperty((Scriptable)scope, (String)"context", (Object)Context.javaToJS((Object)this.mContext, (Scriptable)scope));
        try {
            this.importClasses(jsContext, scope);
            this.importPackages(jsContext, scope);
            this.importConsole(scope);
            this.importVariables(scope);
            this.importFunctions(scope);
        }
        catch (StethoJsException e) {
            String message = String.format("%s\n%s", e.getMessage(), Log.getStackTraceString((Throwable)e));
            LogUtil.e((Throwable)e, (String)message);
            CLog.writeToConsole((Console.MessageLevel)Console.MessageLevel.ERROR, (Console.MessageSource)Console.MessageSource.JAVASCRIPT, (String)message);
        }
        return scope;
    }

    private void importClasses(@NonNull Context jsContext, @NonNull ScriptableObject scope) throws StethoJsException {
        for (Class<?> aClass : this.mClasses) {
            String className = aClass.getName();
            try {
                String expression = String.format("importClass(%s)", className);
                jsContext.evaluateString((Scriptable)scope, expression, SOURCE_NAME, 1, null);
            }
            catch (Exception e) {
                try {
                    String expression = String.format("importClass(Packages.%s)", className);
                    jsContext.evaluateString((Scriptable)scope, expression, SOURCE_NAME, 1, null);
                }
                catch (Exception e1) {
                    throw new StethoJsException(e1, "Failed to import class: %s", className);
                }
            }
        }
    }

    private void importPackages(@NonNull Context jsContext, @NonNull ScriptableObject scope) throws StethoJsException {
        for (String packageName : this.mPackages) {
            try {
                String expression = String.format("importPackage(%s)", packageName);
                jsContext.evaluateString((Scriptable)scope, expression, SOURCE_NAME, 1, null);
            }
            catch (Exception e) {
                try {
                    String expression = String.format("importPackage(Packages.%s)", packageName);
                    jsContext.evaluateString((Scriptable)scope, expression, SOURCE_NAME, 1, null);
                }
                catch (Exception e1) {
                    throw new StethoJsException(e, "Failed to import package: %s", packageName);
                }
            }
        }
    }

    private void importConsole(@NonNull ScriptableObject scope) throws StethoJsException {
        try {
            ScriptableObject.defineClass((Scriptable)scope, JsConsole.class);
            JsConsole console = new JsConsole(scope);
            scope.defineProperty("console", (Object)console, 2);
        }
        catch (Exception e) {
            throw new StethoJsException(e, "Failed to setup javascript console", new Object[0]);
        }
    }

    private void importVariables(@NonNull ScriptableObject scope) throws StethoJsException {
        for (Map.Entry<String, Object> entrySet : this.mVariables.entrySet()) {
            String varName = entrySet.getKey();
            Object varValue = entrySet.getValue();
            try {
                Object jsValue = varValue instanceof Scriptable || varValue instanceof Undefined ? varValue : Context.javaToJS((Object)varValue, (Scriptable)scope);
                ScriptableObject.putProperty((Scriptable)scope, (String)varName, (Object)jsValue);
            }
            catch (Exception e) {
                throw new StethoJsException(e, "Failed to setup variable: %s", varName);
            }
        }
    }

    private void importFunctions(@NonNull ScriptableObject scope) throws StethoJsException {
        for (Map.Entry<String, Function> entrySet : this.mFunctions.entrySet()) {
            String functionName = entrySet.getKey();
            Function function = entrySet.getValue();
            try {
                ScriptableObject.putProperty((Scriptable)scope, (String)functionName, (Object)function);
            }
            catch (Exception e) {
                throw new StethoJsException(e, "Failed to setup function: %s", functionName);
            }
        }
    }

    private static class StethoJsException
    extends Exception {
        StethoJsException(Throwable rootCause, String format, Object ... args) {
            super(args.length == 0 ? format : String.format(format, args), rootCause);
        }
    }
}

