/* The following code was generated by JFlex 1.4.1 on 6/30/19 10:57 PM */

/*
 * This library is distributed under a modified BSD license.  See the included
 * LICENSE file for details.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for the Go programming language.
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated <code>GoTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.6
 *
 */

public class GoTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int EOL_COMMENT = 2;
  public static final int YYINITIAL = 0;
  public static final int MLC = 1;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\32\1\24\1\0\1\32\1\36\22\0\1\32\1\17\1\25"+
    "\1\37\1\40\1\44\1\117\1\14\1\12\1\12\1\33\1\7\1\43"+
    "\1\20\1\34\1\13\1\31\1\71\1\22\1\73\1\74\1\5\1\72"+
    "\1\5\1\70\1\3\1\53\1\42\1\15\1\11\1\16\1\10\1\37"+
    "\1\77\1\107\1\76\1\4\1\6\1\102\1\1\1\103\1\106\1\110"+
    "\1\1\1\111\1\112\1\113\1\1\1\104\1\1\1\100\1\105\1\114"+
    "\1\115\2\1\1\23\2\1\1\41\1\21\1\41\1\121\1\2\1\0"+
    "\1\27\1\55\1\60\1\64\1\30\1\51\1\65\1\45\1\35\1\1"+
    "\1\57\1\52\1\66\1\61\1\62\1\47\1\101\1\56\1\50\1\46"+
    "\1\63\1\26\1\54\1\75\1\67\1\1\1\116\1\120\1\116\1\43"+
    "\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\2\1\3\1\2\3\4\1\5\1\4"+
    "\1\6\3\4\1\2\1\7\1\10\3\2\1\3\1\11"+
    "\1\4\1\2\1\1\1\2\1\4\27\2\2\4\1\12"+
    "\1\13\5\12\1\14\3\12\1\15\2\16\1\2\1\0"+
    "\1\17\1\20\2\21\1\22\1\6\2\10\1\23\3\2"+
    "\1\15\1\3\1\15\1\0\1\24\33\2\1\24\15\2"+
    "\1\25\10\0\1\15\1\2\1\6\1\26\1\6\3\21"+
    "\1\6\2\10\1\27\2\2\1\30\1\31\14\2\1\32"+
    "\14\2\1\33\23\2\10\0\1\16\1\0\1\2\1\6"+
    "\1\10\2\2\1\31\22\2\1\31\15\2\1\32\3\2"+
    "\2\0\1\34\2\0\1\35\3\2\1\32\20\2\2\32"+
    "\10\2\4\0\3\2\1\36\6\2\1\32\20\2\1\32"+
    "\1\2\1\32\7\2\1\32\4\2\1\32\11\2\1\32"+
    "\1\2\1\32\3\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[348];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\122\0\244\0\366\0\u0148\0\u019a\0\u01ec\0\u023e"+
    "\0\u0290\0\u02e2\0\u0334\0\u0386\0\u03d8\0\u042a\0\u047c\0\u04ce"+
    "\0\366\0\u0334\0\u0520\0\u0572\0\u05c4\0\u0616\0\u0668\0\u06ba"+
    "\0\u070c\0\u075e\0\u0334\0\u0334\0\u0334\0\u07b0\0\u0802\0\u0854"+
    "\0\u08a6\0\u08f8\0\u094a\0\u099c\0\u09ee\0\u0a40\0\u0a92\0\u0ae4"+
    "\0\u0b36\0\u0b88\0\u0bda\0\u0c2c\0\u0c7e\0\u0cd0\0\u0d22\0\u0d74"+
    "\0\u0dc6\0\u0e18\0\u0e6a\0\u0ebc\0\u0f0e\0\u0f60\0\u0fb2\0\u0334"+
    "\0\u1004\0\u1056\0\u10a8\0\u10fa\0\u114c\0\u0334\0\u119e\0\u11f0"+
    "\0\u1242\0\u1294\0\u12e6\0\u1294\0\u1338\0\u138a\0\u0334\0\u0334"+
    "\0\u13dc\0\u142e\0\u0334\0\u1480\0\u14d2\0\u1524\0\u0334\0\u1576"+
    "\0\u15c8\0\u161a\0\u166c\0\u16be\0\u1710\0\u1762\0\u0148\0\u17b4"+
    "\0\u1806\0\u1858\0\u18aa\0\u18fc\0\u194e\0\u19a0\0\u19f2\0\u1a44"+
    "\0\u1a96\0\u1ae8\0\u1b3a\0\u1b8c\0\u1bde\0\u1c30\0\u1c82\0\u1cd4"+
    "\0\u1d26\0\u1d78\0\u1dca\0\u1e1c\0\u1e6e\0\u1ec0\0\u1f12\0\u1f64"+
    "\0\u1fb6\0\u2008\0\u205a\0\u20ac\0\u20fe\0\u2150\0\u21a2\0\u21f4"+
    "\0\u2246\0\u2298\0\u22ea\0\u233c\0\u238e\0\u23e0\0\u2432\0\u2484"+
    "\0\u0334\0\u24d6\0\u2528\0\u257a\0\u25cc\0\u261e\0\u2670\0\u26c2"+
    "\0\u2714\0\u2766\0\u27b8\0\u280a\0\u0334\0\u285c\0\u28ae\0\u2900"+
    "\0\u2952\0\u29a4\0\u29f6\0\u2a48\0\u0334\0\u2a9a\0\u2aec\0\u1710"+
    "\0\u2b3e\0\u2b90\0\u2be2\0\u2c34\0\u2c86\0\u2cd8\0\u2d2a\0\u2d7c"+
    "\0\u2dce\0\u2e20\0\u2e72\0\u2ec4\0\u2f16\0\u0148\0\u2f68\0\u2fba"+
    "\0\u300c\0\u305e\0\u30b0\0\u3102\0\u3154\0\u31a6\0\u31f8\0\u324a"+
    "\0\u329c\0\u32ee\0\u0148\0\u3340\0\u3392\0\u33e4\0\u3436\0\u3488"+
    "\0\u34da\0\u352c\0\u357e\0\u35d0\0\u3622\0\u3674\0\u36c6\0\u3718"+
    "\0\u376a\0\u37bc\0\u380e\0\u3860\0\u38b2\0\u3904\0\u3956\0\u39a8"+
    "\0\u39fa\0\u3a4c\0\u3a9e\0\u3af0\0\u3b42\0\u3b94\0\u3be6\0\u3c38"+
    "\0\u3c8a\0\u3cdc\0\u3d2e\0\u3d80\0\u3dd2\0\u0148\0\u3e24\0\u3e76"+
    "\0\u3ec8\0\u3f1a\0\u3f6c\0\u3fbe\0\u4010\0\u4062\0\u40b4\0\u4106"+
    "\0\u4158\0\u41aa\0\u41fc\0\u424e\0\u42a0\0\u42f2\0\u4344\0\u4396"+
    "\0\u43e8\0\u443a\0\u448c\0\u44de\0\u4530\0\u4582\0\u45d4\0\u4626"+
    "\0\u4678\0\u46ca\0\u471c\0\u476e\0\u47c0\0\u4812\0\u4864\0\u48b6"+
    "\0\u4908\0\u495a\0\u49ac\0\u49fe\0\u4a50\0\u4aa2\0\u4af4\0\u4b46"+
    "\0\u4b98\0\u4bea\0\u4c3c\0\u4c8e\0\u4ce0\0\u4d32\0\u4d84\0\u4dd6"+
    "\0\u4e28\0\u4e7a\0\u4ecc\0\u4f1e\0\u4f70\0\u4fc2\0\u5014\0\u5066"+
    "\0\u50b8\0\u510a\0\u515c\0\u51ae\0\u5200\0\u5252\0\u52a4\0\u52f6"+
    "\0\u5348\0\u539a\0\u53ec\0\u543e\0\u5490\0\u54e2\0\u5534\0\u4a50"+
    "\0\u5586\0\u4b46\0\u55d8\0\u562a\0\u567c\0\u0148\0\u56ce\0\u5720"+
    "\0\u5772\0\u57c4\0\u5816\0\u5868\0\u58ba\0\u590c\0\u595e\0\u59b0"+
    "\0\u5a02\0\u5a54\0\u5aa6\0\u5af8\0\u5b4a\0\u5b9c\0\u5bee\0\u5c40"+
    "\0\u5c92\0\u5ce4\0\u5d36\0\u5d88\0\u5dda\0\u5e2c\0\u5e7e\0\u5ed0"+
    "\0\u5f22\0\u5f74\0\u5fc6\0\u6018\0\u606a\0\u60bc\0\u610e\0\u6160"+
    "\0\u61b2\0\u6204\0\u6256\0\u62a8\0\u62fa\0\u634c\0\u639e\0\u63f0"+
    "\0\u6442\0\u6494\0\u6160\0\u64e6\0\u6538\0\u658a\0\u65dc\0\u662e"+
    "\0\u6680\0\u66d2\0\u6724\0\u6776";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[348];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\4\2\5\1\6\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\12\1\20"+
    "\1\21\1\6\1\5\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\12\1\31\1\32\1\33\2\4\1\13"+
    "\1\34\1\35\1\12\1\5\1\36\1\37\1\40\1\41"+
    "\1\42\1\12\1\5\1\43\1\44\1\5\1\45\1\46"+
    "\1\5\1\47\1\50\1\51\1\52\1\5\5\6\1\5"+
    "\1\53\1\5\1\54\1\5\1\55\1\56\1\5\1\57"+
    "\1\60\1\5\1\61\1\62\1\63\1\5\1\64\1\5"+
    "\1\13\1\65\1\66\1\12\24\67\1\70\6\67\1\71"+
    "\11\67\1\72\3\67\1\73\2\67\1\74\45\67\24\75"+
    "\1\76\20\75\1\77\3\75\1\100\2\75\1\101\45\75"+
    "\7\4\12\0\3\4\2\0\4\4\3\0\1\4\1\0"+
    "\2\4\4\0\6\4\1\0\42\4\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\42\5\4\0\3\102"+
    "\1\6\1\102\1\6\1\102\12\0\1\102\1\6\1\102"+
    "\2\0\3\102\1\6\2\0\1\103\1\104\1\0\2\102"+
    "\4\0\6\102\1\0\14\102\5\6\21\102\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\25\5\1\105"+
    "\14\5\13\0\1\35\1\0\1\35\120\0\1\106\122\0"+
    "\1\35\243\0\1\35\1\0\1\107\17\0\1\110\66\0"+
    "\10\111\1\112\3\111\1\113\4\111\1\114\2\111\1\0"+
    "\75\111\11\0\1\35\3\0\1\12\2\0\1\35\112\0"+
    "\1\35\4\0\1\12\114\0\1\35\6\0\1\35\101\0"+
    "\21\23\1\115\2\23\1\116\1\117\74\23\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\1\5\1\120\2\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\2\5\1\121"+
    "\3\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\5\5\1\122\1\0\42\5\4\0\3\102\1\123"+
    "\1\102\1\124\1\102\12\0\1\102\1\124\1\125\2\0"+
    "\3\102\1\124\2\0\1\103\1\104\1\0\2\102\4\0"+
    "\6\102\1\0\14\102\1\123\4\124\1\125\20\102\36\0"+
    "\1\30\72\0\1\103\1\0\1\103\14\0\1\103\6\0"+
    "\1\103\2\0\1\126\33\0\5\103\25\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\4\5\1\127\1\5\1\0\5\5"+
    "\1\130\4\5\1\131\27\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\2\5\1\132\10\5\1\133"+
    "\26\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\1\5\1\134\2\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\2\5\1\135\37\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\136\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\1\5\1\137"+
    "\4\5\1\0\1\140\41\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\141\2\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\5\5\1\142\1\0\6\5"+
    "\1\120\1\143\32\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\2\5\1\144\1\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\2\5\1\145"+
    "\3\5\1\146\4\5\1\147\26\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\1\5\1\150\1\151\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\7\5\1\152\32\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\1\5\1\153\2\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\1\154\4\5\1\155\1\0\6\5"+
    "\1\156\33\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\2\5\1\157\1\5\3\0\1\160\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\161\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\162\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\6\5\1\163\33\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\164\2\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\6\5"+
    "\1\165\33\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\2\5\1\166\1\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\167\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\1\5\1\170\2\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\2\5"+
    "\1\171\3\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\5\5\1\172\34\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\6\5"+
    "\1\173\33\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\1\5\1\174\2\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\1\5\1\175\2\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\176\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\2\5\1\177\3\5\1\200\33\5\15\0\1\35\105\0"+
    "\1\35\1\0\1\12\11\0\1\35\106\0\1\35\1\0"+
    "\24\67\1\0\6\67\1\0\11\67\1\0\3\67\1\0"+
    "\2\67\1\0\45\67\13\0\1\201\154\0\1\202\110\0"+
    "\1\203\10\0\1\204\127\0\1\205\45\0\24\75\1\0"+
    "\20\75\1\0\3\75\1\0\2\75\1\0\45\75\46\0"+
    "\1\206\110\0\1\207\10\0\1\210\127\0\1\211\45\0"+
    "\7\102\12\0\3\102\2\0\4\102\3\0\1\102\1\0"+
    "\2\102\4\0\6\102\1\0\42\102\4\0\3\102\1\103"+
    "\1\102\1\103\1\212\12\0\1\102\1\103\1\102\2\0"+
    "\2\102\1\212\1\103\3\0\1\104\1\0\2\102\4\0"+
    "\6\102\1\0\14\102\5\103\21\102\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\7\5\1\213\32\5"+
    "\15\0\10\35\101\0\14\214\1\215\7\214\1\0\105\214"+
    "\1\216\3\214\1\215\7\214\1\0\102\214\1\217\2\214"+
    "\1\111\3\214\1\220\4\214\1\111\1\221\1\222\1\0"+
    "\4\111\1\221\14\214\1\111\2\214\1\111\3\214\2\111"+
    "\2\214\1\111\7\214\1\221\1\217\1\221\1\217\1\222"+
    "\24\214\5\116\1\23\2\116\1\23\3\116\1\23\4\116"+
    "\2\23\1\223\1\0\5\23\14\116\1\23\2\116\1\23"+
    "\3\116\2\23\2\116\1\23\7\116\4\23\1\223\45\116"+
    "\1\224\3\116\1\225\74\116\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\2\5\1\127\37\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\2\5\1\226\3\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\3\5"+
    "\1\227\2\5\1\0\42\5\4\0\3\102\1\123\1\102"+
    "\1\123\1\102\12\0\1\102\1\123\1\102\2\0\3\102"+
    "\1\123\2\0\1\103\1\104\1\0\2\102\4\0\6\102"+
    "\1\0\14\102\5\123\21\102\4\0\3\102\1\123\1\102"+
    "\1\124\1\102\12\0\1\102\1\124\1\102\2\0\3\102"+
    "\1\124\2\0\1\103\1\104\1\0\2\102\4\0\6\102"+
    "\1\0\14\102\1\123\4\124\21\102\4\0\3\102\4\230"+
    "\12\0\1\102\1\230\1\102\2\0\1\102\3\230\3\0"+
    "\1\102\1\0\2\102\4\0\4\102\1\230\1\102\1\0"+
    "\1\102\1\230\2\102\1\230\3\102\1\230\3\102\5\230"+
    "\1\102\2\230\2\102\1\230\4\102\1\230\6\102\40\0"+
    "\1\35\65\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\231\4\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\232\2\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\2\5\1\233\3\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\7\5\1\234\32\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\2\5\1\227\3\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\4\5"+
    "\1\235\1\236\34\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\237\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\5\5\1\240\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\2\5\1\241"+
    "\37\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\242\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\5\5\1\243\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\6\5\1\244\33\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\5\5"+
    "\1\245\34\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\5\5\1\246\34\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\2\5\1\247\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\6\5\1\250\33\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\1\5\1\251\4\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\5\5\1\252"+
    "\34\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\1\5\1\253\2\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\1\5\1\254\4\5\1\0\4\5\1\255\35\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\5\5\1\251\34\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\2\5\1\246\1\227\2\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\1\5\1\256"+
    "\2\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\6\5\1\257\33\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\2\5\1\260\3\5\1\0\5\5"+
    "\1\261\4\5\1\262\27\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\1\246\41\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\5\5\1\263\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\5\5\1\264\34\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\4\5\1\265\1\266\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\1\5\1\267\4\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\2\5"+
    "\1\127\3\5\1\0\3\5\1\270\36\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\5\5\1\271"+
    "\1\5\1\272\2\5\1\273\27\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\2\5\1\274\3\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\2\5"+
    "\1\275\1\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\3\5\1\276\2\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\5\5\1\277\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\10\5\1\300\31\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\144\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\3\5\1\301\2\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\2\5\1\246\3\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\1\5\1\302\4\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\303\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\35\5\1\304"+
    "\2\5\1\305\1\306\52\0\1\307\125\0\1\310\116\0"+
    "\1\311\126\0\1\312\113\0\1\313\125\0\1\314\116\0"+
    "\1\315\126\0\1\316\45\0\3\102\1\317\1\102\1\317"+
    "\1\102\1\320\10\0\1\320\1\102\1\317\1\102\2\0"+
    "\3\102\1\317\3\0\1\102\1\0\2\102\4\0\6\102"+
    "\1\0\14\102\5\317\21\102\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\321\2\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\14\214\1\113\7\214\1\0\106\214\3\111\1\220\4\111"+
    "\3\214\1\0\102\214\1\111\6\214\1\215\5\214\1\111"+
    "\1\214\1\0\4\214\1\111\37\214\4\111\25\214\14\0"+
    "\1\215\105\0\5\214\1\217\6\214\1\215\5\214\1\217"+
    "\1\214\1\0\4\214\1\217\37\214\4\217\30\214\4\322"+
    "\5\214\1\113\5\214\1\322\1\214\1\0\2\214\3\322"+
    "\17\214\1\322\3\214\1\322\2\214\1\322\3\214\1\322"+
    "\3\214\5\322\1\214\2\322\2\214\1\322\4\214\1\322"+
    "\12\214\3\116\4\323\12\116\1\224\1\323\2\116\1\225"+
    "\1\116\3\323\17\116\1\323\3\116\1\323\2\116\1\323"+
    "\3\116\1\323\3\116\5\323\1\116\2\323\2\116\1\323"+
    "\4\116\1\323\36\116\1\0\75\116\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\2\5\1\324\1\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\2\5\1\127"+
    "\1\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\2\5\1\325\1\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\14\5\1\326\1\327\1\330"+
    "\1\331\22\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\11\5\1\246\30\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\6\5\1\332\33\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\2\5"+
    "\1\263\1\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\3\5\1\333\36\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\334"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\5\5"+
    "\1\335\34\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\2\5\1\336\1\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\337\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\7\5\1\336\32\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\1\5\1\340"+
    "\4\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\3\5\1\234\1\5\1\341\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\1\5\1\342"+
    "\2\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\4\5\1\127\35\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\1\5\1\343\2\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\5\5\1\326"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\2\5\1\326\1\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\11\5\1\227\30\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\5\5\1\246"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\7\5\1\344\32\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\6\5\1\345\33\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\5\5\1\127\34\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\3\5\1\270\2\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\13\5\1\246"+
    "\26\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\346\1\5\1\347\2\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\2\5\1\350\3\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\351\4\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\352\1\120\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\2\5"+
    "\1\353\1\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\6\5\1\127\33\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\246\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\354\4\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\5\5\1\355\34\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\2\5\1\356\3\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\2\5\1\357\1\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\5\5\1\360\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\5\5\1\361\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\30\5\1\362\1\363\10\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\364\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\2\5\1\365\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\1\5\1\366"+
    "\4\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\5\5\1\270\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\12\5\1\367\27\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\6\5\1\370\33\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\371\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\2\5\1\372\3\5\1\0\42\5\53\0"+
    "\1\373\102\0\1\311\144\0\1\374\102\0\1\375\134\0"+
    "\1\376\102\0\1\315\144\0\1\377\102\0\1\u0100\65\0"+
    "\3\102\1\317\1\102\1\317\1\102\12\0\1\102\1\317"+
    "\1\102\2\0\3\102\1\317\3\0\1\104\1\0\2\102"+
    "\4\0\6\102\1\0\14\102\5\317\21\102\7\0\1\317"+
    "\1\0\1\317\14\0\1\317\6\0\1\317\36\0\5\317"+
    "\25\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\5\5\1\u0101"+
    "\1\0\42\5\4\0\3\214\4\111\5\214\1\113\5\214"+
    "\1\111\1\214\1\0\2\214\3\111\17\214\1\111\3\214"+
    "\1\111\2\214\1\111\3\214\1\111\3\214\5\111\1\214"+
    "\2\111\2\214\1\111\4\214\1\111\12\214\3\116\4\23"+
    "\12\116\1\224\1\23\2\116\1\225\1\116\3\23\17\116"+
    "\1\23\3\116\1\23\2\116\1\23\3\116\1\23\3\116"+
    "\5\23\1\116\2\23\2\116\1\23\4\116\1\23\12\116"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\5\5"+
    "\1\u0102\34\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\2\5\1\u0103\37\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\16\5\1\326\23\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\20\5\1\326\21\5\4\0\1\4\6\5\12\0\1\4"+
    "\1\326\1\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\2\5\1\347\37\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\1\5"+
    "\1\252\2\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\4\5\1\246\35\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\1\5\1\u0104\4\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\4\5\1\347\35\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\5\5\1\u0105\34\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\4\5"+
    "\1\u0106\35\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\1\5\1\u0107\4\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\1\5\1\u0108\4\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\3\5\1\127\36\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\2\5\1\u0109\37\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\1\u010a\3\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\u010b\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\127\4\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\5\5\1\u010c\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\2\5\1\u010d\3\5\1\0"+
    "\14\5\1\326\1\327\1\330\1\331\22\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\7\5\1\u010e"+
    "\32\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\270\4\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\u010f\2\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\1\5\1\246\4\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\1\5\1\u0110\2\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\1\5\1\355\2\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\1\5"+
    "\1\u0111\2\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\10\5\1\u0112\31\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\2\5\1\u0113"+
    "\37\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\7\5\1\u0114\32\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\1\5\1\u0115\4\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\21\5"+
    "\1\u0116\20\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\32\5\1\u0117\7\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\24\5\1\u0118\1\5"+
    "\1\u0119\1\5\1\362\1\u011a\3\5\1\u011b\4\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\1\u011c"+
    "\41\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\1\5"+
    "\1\u011d\4\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\2\5\1\u011e\3\5\1\0\42\5\54\0"+
    "\1\311\2\0\1\374\61\0\1\u011f\107\0\1\375\1\u0120"+
    "\4\375\4\u0120\1\375\1\u0120\2\0\2\u0120\1\0\2\375"+
    "\2\0\4\375\1\0\2\u0120\1\375\1\0\1\u0120\1\375"+
    "\4\u0120\6\375\1\u0120\42\375\1\0\1\u0120\52\0\1\315"+
    "\2\0\1\377\61\0\1\u0121\107\0\1\u0100\1\u0122\4\u0100"+
    "\4\u0122\1\u0100\1\u0122\2\0\2\u0122\1\0\2\u0100\2\0"+
    "\4\u0100\1\0\2\u0122\1\u0100\1\0\1\u0122\1\u0100\4\u0122"+
    "\6\u0100\1\u0122\42\u0100\1\0\1\u0122\2\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\3\5\1\u0123\2\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\10\5\1\246\31\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\4\5\1\u0124\1\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\5\5\1\144\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\11\5\1\326\30\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\1\127\5\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\1\u0125\5\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\16\5"+
    "\1\330\1\331\22\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\5\5\1\u0126\34\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\u0127\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\5\5\1\u0128\34\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\2\5\1\u0129\1\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\1\5\1\u012a\4\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\5\5\1\347\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\u012b\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\2\5\1\270\37\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\4\5\1\u012c\35\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\3\5\1\u012d\2\5\1\0\42\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\u012e\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\4\5"+
    "\1\u012e\1\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\23\5\1\u012f\13\5\1\246"+
    "\2\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\23\5\1\u0130\1\u0131\1\5\1\u0119\4\5\1\u0132"+
    "\6\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\5\5\1\u0133\34\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\u0134\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\7\5\1\u0135\32\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\2\5\1\u0136"+
    "\3\5\1\0\7\5\1\u0114\32\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\2\5\1\u0137\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\2\5"+
    "\1\u0138\1\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\5\5\1\u0139\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\2\5\1\u0127\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\3\5\1\u013a\2\5"+
    "\1\0\42\5\17\0\1\375\121\0\1\u0100\106\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\26\5\1\u013b"+
    "\13\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\1\5\1\u013c\2\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\42\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\2\5\1\u013d\37\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\2\5"+
    "\1\246\37\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\7\5\1\227\32\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\21\5\1\u013e\20\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\2\5\1\326\37\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\5\5\1\u013f\34\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\u0140\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\26\5\1\u0119\13\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\4\5\1\u0141\1\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\4\5\1\u0142\1\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\5\5\1\260\34\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\7\5\1\u0143\32\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\13\5\1\353\26\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\10\5\1\u0144\31\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\11\5\1\u0145"+
    "\30\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\5\5\1\334\34\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\1\5\1\u0146\2\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\4\5\1\u0147\1\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\2\5\1\u0148\37\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\2\5\1\u0148\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\2\5"+
    "\1\u0149\1\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\6\5\1\u014a\33\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\4\5\1\227"+
    "\35\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\6\5\1\u014b\33\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\15\5\1\u014c\1\330\23\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\3\5\1\u014d"+
    "\2\5\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\23\5\1\u014e\16\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\u014f"+
    "\1\0\1\4\1\5\4\0\6\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\1\5\1\u0150\4\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\5\5\1\270\34\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\2\5\1\u0151\1\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\1\u0147\5\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\4\5\1\270\35\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\1\5\1\u012d\4\5\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\31\5\1\u0152\10\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\2\5\1\u0153\37\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\4\5\3\0\1\5"+
    "\1\0\1\4\1\5\4\0\5\5\1\u0102\1\0\42\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\7\5\1\u0154\32\5\4\0\1\4\6\5\12\0\1\4"+
    "\1\u0155\1\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\6\5\1\0\42\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\23\5\1\u0130\1\u0131"+
    "\15\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\5\5"+
    "\1\253\1\0\42\5\4\0\1\4\6\5\12\0\1\4"+
    "\2\5\2\0\4\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\21\5\1\246\20\5\4\0\1\4"+
    "\6\5\12\0\1\4\2\5\2\0\2\5\1\u0156\1\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\4\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\21\5\1\u0157\20\5\4\0\1\4\6\5\12\0"+
    "\1\4\2\5\2\0\4\5\3\0\1\5\1\0\1\4"+
    "\1\5\4\0\2\5\1\u0158\3\5\1\0\42\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\4\5\3\0"+
    "\1\5\1\0\1\4\1\5\4\0\6\5\1\0\11\5"+
    "\1\u0106\30\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\14\5\1\326\25\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\2\5\1\u0159\37\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\5\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\23\5\1\u0130\2\5\1\u0119\4\5\1\u0132\6\5\4\0"+
    "\1\4\6\5\12\0\1\4\2\5\2\0\2\5\1\u015a"+
    "\1\5\3\0\1\5\1\0\1\4\1\5\4\0\6\5"+
    "\1\0\42\5\4\0\1\4\6\5\12\0\1\4\2\5"+
    "\2\0\4\5\3\0\1\5\1\0\1\4\1\5\4\0"+
    "\6\5\1\0\37\5\1\246\2\5\4\0\1\4\6\5"+
    "\12\0\1\4\2\5\2\0\4\5\3\0\1\5\1\0"+
    "\1\4\1\5\4\0\6\5\1\0\4\5\1\u015b\35\5"+
    "\4\0\1\4\6\5\12\0\1\4\2\5\2\0\4\5"+
    "\3\0\1\u015c\1\0\1\4\1\5\4\0\6\5\1\0"+
    "\42\5\4\0\1\4\6\5\12\0\1\4\2\5\2\0"+
    "\1\5\1\253\2\5\3\0\1\5\1\0\1\4\1\5"+
    "\4\0\6\5\1\0\42\5\4\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[26568];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\7\1\1\11\6\1\1\11\10\1\3\11\32\1"+
    "\1\11\5\1\1\11\7\1\1\0\2\11\2\1\1\11"+
    "\3\1\1\11\6\1\1\0\52\1\1\11\10\0\3\1"+
    "\1\11\7\1\1\11\61\1\10\0\1\1\1\0\52\1"+
    "\2\0\1\1\2\0\37\1\4\0\72\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[348];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public GoTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	@Override
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String[] getLineCommentStartAndEnd(int languageIndex) {
		return new String[] { "//", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *                    <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = YYINITIAL;
		switch (initialTokenType) {
			case Token.COMMENT_MULTILINE:
				state = MLC;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new TokenImpl();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = zzPushbackPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtBOL  = true;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public GoTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public GoTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 202) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 7: 
          { addNullToken(); return firstToken;
          }
        case 31: break;
        case 22: 
          { addToken(Token.LITERAL_CHAR);
          }
        case 32: break;
        case 21: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 33: break;
        case 16: 
          { start = zzMarkedPos-2; yybegin(MLC);
          }
        case 34: break;
        case 9: 
          { addToken(Token.WHITESPACE);
          }
        case 35: break;
        case 24: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 36: break;
        case 17: 
          { addToken(Token.ERROR_CHAR); /*addNullToken(); return firstToken;*/
          }
        case 37: break;
        case 23: 
          { addToken(Token.ERROR_STRING_DOUBLE);
          }
        case 38: break;
        case 14: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 39: break;
        case 20: 
          { addToken(Token.RESERVED_WORD);
          }
        case 40: break;
        case 5: 
          { addToken(Token.SEPARATOR);
          }
        case 41: break;
        case 2: 
          { addToken(Token.IDENTIFIER);
          }
        case 42: break;
        case 12: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 43: break;
        case 15: 
          { start = zzMarkedPos-2; yybegin(EOL_COMMENT);
          }
        case 44: break;
        case 26: 
          { addToken(Token.FUNCTION);
          }
        case 45: break;
        case 6: 
          { addToken(Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 46: break;
        case 8: 
          { addToken(Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 47: break;
        case 25: 
          { addToken(Token.DATA_TYPE);
          }
        case 48: break;
        case 1: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 49: break;
        case 18: 
          { addToken(Token.ERROR_CHAR);
          }
        case 50: break;
        case 27: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 51: break;
        case 19: 
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 52: break;
        case 29: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 53: break;
        case 28: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 54: break;
        case 30: 
          { addToken(Token.RESERVED_WORD_2);
          }
        case 55: break;
        case 13: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 56: break;
        case 3: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 57: break;
        case 4: 
          { addToken(Token.OPERATOR);
          }
        case 58: break;
        case 10: 
          { 
          }
        case 59: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 60: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 349: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 350: break;
            case MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 351: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
