/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import com.facebook.login.LoginManager;
import com.firebase.ui.auth.AuthMethodPickerLayout;
import com.firebase.ui.auth.KickoffActivity;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.util.CredentialUtils;
import com.firebase.ui.auth.util.GoogleApiUtils;
import com.firebase.ui.auth.util.Preconditions;
import com.firebase.ui.auth.util.data.PhoneNumberUtils;
import com.firebase.ui.auth.util.data.ProviderAvailability;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.CredentialRequest;
import com.google.android.gms.auth.api.credentials.CredentialRequestResponse;
import com.google.android.gms.auth.api.credentials.CredentialsClient;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GoogleAuthProvider;
import com.google.firebase.auth.UserInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class AuthUI {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String TAG = "AuthUI";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String ANONYMOUS_PROVIDER = "anonymous";
    public static final String EMAIL_LINK_PROVIDER = "emailLink";
    public static final String MICROSOFT_PROVIDER = "microsoft.com";
    public static final String YAHOO_PROVIDER = "yahoo.com";
    public static final String APPLE_PROVIDER = "apple.com";
    public static final int NO_LOGO = -1;
    public static final Set<String> SUPPORTED_PROVIDERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("google.com", "facebook.com", "twitter.com", "github.com", "password", "phone", "anonymous", "emailLink")));
    public static final Set<String> SUPPORTED_OAUTH_PROVIDERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("microsoft.com", "yahoo.com", "apple.com", "twitter.com", "github.com")));
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Set<String> SOCIAL_PROVIDERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("google.com", "facebook.com")));
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String UNCONFIGURED_CONFIG_VALUE = "CHANGE-ME";
    private static final IdentityHashMap<FirebaseApp, AuthUI> INSTANCES = new IdentityHashMap();
    private static Context sApplicationContext;
    private final FirebaseApp mApp;
    private final FirebaseAuth mAuth;

    private AuthUI(FirebaseApp app) {
        this.mApp = app;
        this.mAuth = FirebaseAuth.getInstance((FirebaseApp)this.mApp);
        try {
            this.mAuth.setFirebaseUIVersion("6.4.0");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Couldn't set the FUI version.", (Throwable)e);
        }
        this.mAuth.useAppLanguage();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setApplicationContext(@NonNull Context context) {
        sApplicationContext = Preconditions.checkNotNull(context, "App context cannot be null.", new Object[0]).getApplicationContext();
    }

    @NonNull
    public static AuthUI getInstance() {
        return AuthUI.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static AuthUI getInstance(@NonNull FirebaseApp app) {
        AuthUI authUi;
        String releaseUrl = "https://github.com/firebase/FirebaseUI-Android/releases/tag/6.2.0";
        String devWarning = "Beginning with FirebaseUI 6.2.0 you no longer need to include %s to sign in with %s. Go to %s for more information";
        if (ProviderAvailability.IS_TWITTER_AVAILABLE) {
            Log.w((String)TAG, (String)String.format(devWarning, "the TwitterKit SDK", "Twitter", releaseUrl));
        }
        if (ProviderAvailability.IS_GITHUB_AVAILABLE) {
            Log.w((String)TAG, (String)String.format(devWarning, "com.firebaseui:firebase-ui-auth-github", "GitHub", releaseUrl));
        }
        IdentityHashMap<FirebaseApp, AuthUI> identityHashMap = INSTANCES;
        synchronized (identityHashMap) {
            authUi = INSTANCES.get(app);
            if (authUi == null) {
                authUi = new AuthUI(app);
                INSTANCES.put(app, authUi);
            }
        }
        return authUi;
    }

    public static boolean canHandleIntent(@NonNull Intent intent) {
        if (intent == null || intent.getData() == null) {
            return false;
        }
        String link = intent.getData().toString();
        return FirebaseAuth.getInstance().isSignInWithEmailLink(link);
    }

    @StyleRes
    public static int getDefaultTheme() {
        return R.style.FirebaseUI;
    }

    private static List<Credential> getCredentialsFromFirebaseUser(@NonNull FirebaseUser user) {
        if (TextUtils.isEmpty((CharSequence)user.getEmail()) && TextUtils.isEmpty((CharSequence)user.getPhoneNumber())) {
            return Collections.emptyList();
        }
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        for (UserInfo userInfo : user.getProviderData()) {
            if ("firebase".equals(userInfo.getProviderId())) continue;
            String type = ProviderUtils.providerIdToAccountType(userInfo.getProviderId());
            if (type == null) {
                credentials.add(CredentialUtils.buildCredentialOrThrow(user, "pass", null));
                continue;
            }
            credentials.add(CredentialUtils.buildCredentialOrThrow(user, null, type));
        }
        return credentials;
    }

    @NonNull
    public Task<AuthResult> silentSignIn(@NonNull Context context, @NonNull List<IdpConfig> configs) {
        GoogleSignInOptions googleOptions;
        if (this.mAuth.getCurrentUser() != null) {
            throw new IllegalArgumentException("User already signed in!");
        }
        final Context appContext = context.getApplicationContext();
        IdpConfig google = ProviderUtils.getConfigFromIdps(configs, "google.com");
        IdpConfig email = ProviderUtils.getConfigFromIdps(configs, "password");
        if (google == null && email == null) {
            throw new IllegalArgumentException("No supported providers were supplied. Add either Google or email support.");
        }
        if (google == null) {
            googleOptions = null;
        } else {
            GoogleSignInAccount last = GoogleSignIn.getLastSignedInAccount((Context)appContext);
            if (last != null && last.getIdToken() != null) {
                return this.mAuth.signInWithCredential(GoogleAuthProvider.getCredential((String)last.getIdToken(), null));
            }
            googleOptions = (GoogleSignInOptions)google.getParams().getParcelable("extra_google_sign_in_options");
        }
        return GoogleApiUtils.getCredentialsClient(context).request(new CredentialRequest.Builder().setPasswordLoginSupported(email != null).setAccountTypes(new String[]{google == null ? null : ProviderUtils.providerIdToAccountType("google.com")}).build()).continueWithTask((Continuation)new Continuation<CredentialRequestResponse, Task<AuthResult>>(){

            public Task<AuthResult> then(@NonNull Task<CredentialRequestResponse> task) {
                Credential credential = ((CredentialRequestResponse)task.getResult()).getCredential();
                String email = credential.getId();
                String password = credential.getPassword();
                if (TextUtils.isEmpty((CharSequence)password)) {
                    return GoogleSignIn.getClient((Context)appContext, (GoogleSignInOptions)new GoogleSignInOptions.Builder(googleOptions).setAccountName(email).build()).silentSignIn().continueWithTask((Continuation)new Continuation<GoogleSignInAccount, Task<AuthResult>>(){

                        public Task<AuthResult> then(@NonNull Task<GoogleSignInAccount> task) {
                            AuthCredential authCredential = GoogleAuthProvider.getCredential((String)((GoogleSignInAccount)task.getResult()).getIdToken(), null);
                            return AuthUI.this.mAuth.signInWithCredential(authCredential);
                        }
                    });
                }
                return AuthUI.this.mAuth.signInWithEmailAndPassword(email, password);
            }
        });
    }

    @NonNull
    public Task<Void> signOut(@NonNull Context context) {
        Task maybeDisableAutoSignIn = GoogleApiUtils.getCredentialsClient(context).disableAutoSignIn().continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(@NonNull Task<Void> task) {
                Exception e = task.getException();
                if (e instanceof ApiException && ((ApiException)((Object)e)).getStatusCode() == 16) {
                    Log.w((String)AuthUI.TAG, (String)"Could not disable auto-sign in, maybe there are no SmartLock accounts available?", (Throwable)e);
                    return null;
                }
                return (Void)task.getResult();
            }
        });
        return Tasks.whenAll((Task[])new Task[]{this.signOutIdps(context), maybeDisableAutoSignIn}).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(@NonNull Task<Void> task) {
                task.getResult();
                AuthUI.this.mAuth.signOut();
                return null;
            }
        });
    }

    @NonNull
    public Task<Void> delete(@NonNull Context context) {
        final FirebaseUser currentUser = this.mAuth.getCurrentUser();
        if (currentUser == null) {
            return Tasks.forException((Exception)new FirebaseAuthInvalidUserException(String.valueOf(4), "No currently signed in user."));
        }
        final List<Credential> credentials = AuthUI.getCredentialsFromFirebaseUser(currentUser);
        final CredentialsClient client = GoogleApiUtils.getCredentialsClient(context);
        return this.signOutIdps(context).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(@NonNull Task<Void> task) {
                task.getResult();
                ArrayList<Task> credentialTasks = new ArrayList<Task>();
                for (Credential credential : credentials) {
                    credentialTasks.add(client.delete(credential));
                }
                return Tasks.whenAll(credentialTasks).continueWith((Continuation)new Continuation<Void, Void>(){

                    public Void then(@NonNull Task<Void> task) {
                        Throwable t;
                        Exception e = task.getException();
                        Throwable throwable = t = e == null ? null : e.getCause();
                        if (!(t instanceof ApiException) || ((ApiException)t).getStatusCode() != 16) {
                            return (Void)task.getResult();
                        }
                        return null;
                    }
                });
            }
        }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(@NonNull Task<Void> task) {
                task.getResult();
                return currentUser.delete();
            }
        });
    }

    private Task<Void> signOutIdps(@NonNull Context context) {
        if (ProviderAvailability.IS_FACEBOOK_AVAILABLE) {
            LoginManager.getInstance().logOut();
        }
        return GoogleSignIn.getClient((Context)context, (GoogleSignInOptions)GoogleSignInOptions.DEFAULT_SIGN_IN).signOut();
    }

    @NonNull
    public SignInIntentBuilder createSignInIntentBuilder() {
        return new SignInIntentBuilder();
    }

    public final class SignInIntentBuilder
    extends AuthIntentBuilder<SignInIntentBuilder> {
        private String mEmailLink;
        private boolean mEnableAnonymousUpgrade;

        private SignInIntentBuilder() {
        }

        @NonNull
        public SignInIntentBuilder setEmailLink(@NonNull String emailLink) {
            this.mEmailLink = emailLink;
            return this;
        }

        @NonNull
        public SignInIntentBuilder enableAnonymousUsersAutoUpgrade() {
            this.mEnableAnonymousUpgrade = true;
            this.validateEmailBuilderConfig();
            return this;
        }

        private void validateEmailBuilderConfig() {
            for (int i = 0; i < this.mProviders.size(); ++i) {
                boolean emailLinkForceSameDevice;
                IdpConfig config = (IdpConfig)this.mProviders.get(i);
                if (!config.getProviderId().equals(AuthUI.EMAIL_LINK_PROVIDER) || (emailLinkForceSameDevice = config.getParams().getBoolean("force_same_device", true))) continue;
                throw new IllegalStateException("You must force the same device flow when using email link sign in with anonymous user upgrade");
            }
        }

        @Override
        protected FlowParameters getFlowParams() {
            return new FlowParameters(AuthUI.this.mApp.getName(), this.mProviders, this.mDefaultProvider, this.mTheme, this.mLogo, this.mTosUrl, this.mPrivacyPolicyUrl, this.mEnableCredentials, this.mEnableHints, this.mEnableAnonymousUpgrade, this.mAlwaysShowProviderChoice, this.mLockOrientation, this.mEmailLink, this.mPasswordSettings, this.mAuthMethodPickerLayout);
        }
    }

    private abstract class AuthIntentBuilder<T extends AuthIntentBuilder> {
        final List<IdpConfig> mProviders = new ArrayList<IdpConfig>();
        IdpConfig mDefaultProvider = null;
        int mLogo = -1;
        int mTheme = AuthUI.getDefaultTheme();
        String mTosUrl;
        String mPrivacyPolicyUrl;
        boolean mAlwaysShowProviderChoice = false;
        boolean mLockOrientation = false;
        boolean mEnableCredentials = true;
        boolean mEnableHints = true;
        AuthMethodPickerLayout mAuthMethodPickerLayout = null;
        ActionCodeSettings mPasswordSettings = null;

        private AuthIntentBuilder() {
        }

        @NonNull
        public T setTheme(@StyleRes int theme) {
            this.mTheme = Preconditions.checkValidStyle(AuthUI.this.mApp.getApplicationContext(), theme, "theme identifier is unknown or not a style definition", new Object[0]);
            return (T)this;
        }

        @NonNull
        public T setLogo(@DrawableRes int logo) {
            this.mLogo = logo;
            return (T)this;
        }

        @Deprecated
        @NonNull
        public T setTosUrl(@Nullable String tosUrl) {
            this.mTosUrl = tosUrl;
            return (T)this;
        }

        @Deprecated
        @NonNull
        public T setPrivacyPolicyUrl(@Nullable String privacyPolicyUrl) {
            this.mPrivacyPolicyUrl = privacyPolicyUrl;
            return (T)this;
        }

        @NonNull
        public T setTosAndPrivacyPolicyUrls(@NonNull String tosUrl, @NonNull String privacyPolicyUrl) {
            Preconditions.checkNotNull(tosUrl, "tosUrl cannot be null", new Object[0]);
            Preconditions.checkNotNull(privacyPolicyUrl, "privacyPolicyUrl cannot be null", new Object[0]);
            this.mTosUrl = tosUrl;
            this.mPrivacyPolicyUrl = privacyPolicyUrl;
            return (T)this;
        }

        @NonNull
        public T setAvailableProviders(@NonNull List<IdpConfig> idpConfigs) {
            Preconditions.checkNotNull(idpConfigs, "idpConfigs cannot be null", new Object[0]);
            if (idpConfigs.size() == 1 && idpConfigs.get(0).getProviderId().equals(AuthUI.ANONYMOUS_PROVIDER)) {
                throw new IllegalStateException("Sign in as guest cannot be the only sign in method. In this case, sign the user in anonymously your self; no UI is needed.");
            }
            this.mProviders.clear();
            for (IdpConfig config : idpConfigs) {
                if (this.mProviders.contains(config)) {
                    throw new IllegalArgumentException("Each provider can only be set once. " + config.getProviderId() + " was set twice.");
                }
                this.mProviders.add(config);
            }
            return (T)this;
        }

        @NonNull
        public T setDefaultProvider(@Nullable IdpConfig config) {
            if (config != null) {
                if (!this.mProviders.contains(config)) {
                    throw new IllegalStateException("Default provider not in available providers list.");
                }
                if (this.mAlwaysShowProviderChoice) {
                    throw new IllegalStateException("Can't set default provider and always show provider choice.");
                }
            }
            this.mDefaultProvider = config;
            return (T)this;
        }

        @NonNull
        public T setIsSmartLockEnabled(boolean enabled) {
            return this.setIsSmartLockEnabled(enabled, enabled);
        }

        @NonNull
        public T setIsSmartLockEnabled(boolean enableCredentials, boolean enableHints) {
            this.mEnableCredentials = enableCredentials;
            this.mEnableHints = enableHints;
            return (T)this;
        }

        @NonNull
        public T setAuthMethodPickerLayout(@NonNull AuthMethodPickerLayout authMethodPickerLayout) {
            this.mAuthMethodPickerLayout = authMethodPickerLayout;
            return (T)this;
        }

        @NonNull
        public T setAlwaysShowSignInMethodScreen(boolean alwaysShow) {
            if (alwaysShow && this.mDefaultProvider != null) {
                throw new IllegalStateException("Can't show provider choice with a default provider.");
            }
            this.mAlwaysShowProviderChoice = alwaysShow;
            return (T)this;
        }

        @NonNull
        public T setLockOrientation(boolean lockOrientation) {
            this.mLockOrientation = lockOrientation;
            return (T)this;
        }

        @NonNull
        public T setResetPasswordSettings(ActionCodeSettings passwordSettings) {
            this.mPasswordSettings = passwordSettings;
            return (T)this;
        }

        @CallSuper
        @NonNull
        public Intent build() {
            if (this.mProviders.isEmpty()) {
                this.mProviders.add(new IdpConfig.EmailBuilder().build());
            }
            return KickoffActivity.createIntent(AuthUI.this.mApp.getApplicationContext(), this.getFlowParams());
        }

        protected abstract FlowParameters getFlowParams();
    }

    public static final class IdpConfig
    implements Parcelable {
        public static final Parcelable.Creator<IdpConfig> CREATOR = new Parcelable.Creator<IdpConfig>(){

            public IdpConfig createFromParcel(Parcel in) {
                return new IdpConfig(in);
            }

            public IdpConfig[] newArray(int size) {
                return new IdpConfig[size];
            }
        };
        private final String mProviderId;
        private final Bundle mParams;

        private IdpConfig(@NonNull String providerId, @NonNull Bundle params) {
            this.mProviderId = providerId;
            this.mParams = new Bundle(params);
        }

        private IdpConfig(Parcel in) {
            this.mProviderId = in.readString();
            this.mParams = in.readBundle(this.getClass().getClassLoader());
        }

        @NonNull
        public String getProviderId() {
            return this.mProviderId;
        }

        @NonNull
        public Bundle getParams() {
            return new Bundle(this.mParams);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeString(this.mProviderId);
            parcel.writeBundle(this.mParams);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdpConfig config = (IdpConfig)o;
            return this.mProviderId.equals(config.mProviderId);
        }

        public final int hashCode() {
            return this.mProviderId.hashCode();
        }

        public String toString() {
            return "IdpConfig{mProviderId='" + this.mProviderId + '\'' + ", mParams=" + this.mParams + '}';
        }

        public static class GenericOAuthProviderBuilder
        extends Builder {
            GenericOAuthProviderBuilder(@NonNull String providerId, @NonNull String providerName, int buttonId) {
                super(providerId);
                Preconditions.checkNotNull(providerId, "The provider ID cannot be null.", new Object[0]);
                Preconditions.checkNotNull(providerName, "The provider name cannot be null.", new Object[0]);
                this.getParams().putString("generic_oauth_provider_id", providerId);
                this.getParams().putString("generic_oauth_provider_name", providerName);
                this.getParams().putInt("generic_oauth_button_id", buttonId);
            }

            @NonNull
            public GenericOAuthProviderBuilder setScopes(@NonNull List<String> scopes) {
                this.getParams().putStringArrayList("generic_oauth_scopes", new ArrayList<String>(scopes));
                return this;
            }

            @NonNull
            public GenericOAuthProviderBuilder setCustomParameters(@NonNull Map<String, String> customParameters) {
                this.getParams().putSerializable("generic_oauth_custom_parameters", new HashMap<String, String>(customParameters));
                return this;
            }
        }

        public static final class YahooBuilder
        extends GenericOAuthProviderBuilder {
            private static final String PROVIDER_NAME = "Yahoo";

            public YahooBuilder() {
                super(AuthUI.YAHOO_PROVIDER, PROVIDER_NAME, R.layout.fui_idp_button_yahoo);
            }
        }

        public static final class MicrosoftBuilder
        extends GenericOAuthProviderBuilder {
            private static final String PROVIDER_NAME = "Microsoft";

            public MicrosoftBuilder() {
                super(AuthUI.MICROSOFT_PROVIDER, PROVIDER_NAME, R.layout.fui_idp_button_microsoft);
            }
        }

        public static final class AppleBuilder
        extends GenericOAuthProviderBuilder {
            private static final String PROVIDER_NAME = "Apple";

            public AppleBuilder() {
                super(AuthUI.APPLE_PROVIDER, PROVIDER_NAME, R.layout.fui_idp_button_apple);
            }
        }

        public static final class GitHubBuilder
        extends GenericOAuthProviderBuilder {
            private static final String PROVIDER_NAME = "Github";

            public GitHubBuilder() {
                super("github.com", PROVIDER_NAME, R.layout.fui_idp_button_github);
            }

            @Deprecated
            @NonNull
            public GitHubBuilder setPermissions(@NonNull List<String> permissions) {
                this.setScopes(permissions);
                return this;
            }
        }

        public static final class TwitterBuilder
        extends GenericOAuthProviderBuilder {
            private static final String PROVIDER_NAME = "Twitter";

            public TwitterBuilder() {
                super("twitter.com", PROVIDER_NAME, R.layout.fui_idp_button_twitter);
            }
        }

        public static final class AnonymousBuilder
        extends Builder {
            public AnonymousBuilder() {
                super(AuthUI.ANONYMOUS_PROVIDER);
            }
        }

        public static final class FacebookBuilder
        extends Builder {
            private static final String TAG = "FacebookBuilder";

            public FacebookBuilder() {
                super("facebook.com");
                if (!ProviderAvailability.IS_FACEBOOK_AVAILABLE) {
                    throw new RuntimeException("Facebook provider cannot be configured without dependency. Did you forget to add 'com.facebook.android:facebook-login:VERSION' dependency?");
                }
                Preconditions.checkConfigured(AuthUI.getApplicationContext(), "Facebook provider unconfigured. Make sure to add a `facebook_application_id` string. See the docs for more info: https://github.com/firebase/FirebaseUI-Android/blob/master/auth/README.md#facebook", R.string.facebook_application_id);
                if (AuthUI.getApplicationContext().getString(R.string.facebook_login_protocol_scheme).equals("fbYOUR_APP_ID")) {
                    Log.w((String)TAG, (String)"Facebook provider unconfigured for Chrome Custom Tabs.");
                }
            }

            @NonNull
            public FacebookBuilder setPermissions(@NonNull List<String> permissions) {
                this.getParams().putStringArrayList("extra_facebook_permissions", new ArrayList<String>(permissions));
                return this;
            }
        }

        public static final class GoogleBuilder
        extends Builder {
            public GoogleBuilder() {
                super("google.com");
                Preconditions.checkConfigured(AuthUI.getApplicationContext(), "Check your google-services plugin configuration, the default_web_client_id string wasn't populated.", R.string.default_web_client_id);
            }

            @NonNull
            public GoogleBuilder setScopes(@NonNull List<String> scopes) {
                GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail();
                for (String scope : scopes) {
                    builder.requestScopes(new Scope(scope), new Scope[0]);
                }
                return this.setSignInOptions(builder.build());
            }

            @NonNull
            public GoogleBuilder setSignInOptions(@NonNull GoogleSignInOptions options) {
                Preconditions.checkUnset(this.getParams(), "Cannot overwrite previously set sign-in options.", "extra_google_sign_in_options");
                GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder(options);
                builder.requestEmail().requestIdToken(AuthUI.getApplicationContext().getString(R.string.default_web_client_id));
                this.getParams().putParcelable("extra_google_sign_in_options", (Parcelable)builder.build());
                return this;
            }

            @Override
            @NonNull
            public IdpConfig build() {
                if (!this.getParams().containsKey("extra_google_sign_in_options")) {
                    this.setScopes(Collections.emptyList());
                }
                return super.build();
            }
        }

        public static final class PhoneBuilder
        extends Builder {
            public PhoneBuilder() {
                super("phone");
            }

            @NonNull
            public PhoneBuilder setDefaultNumber(@NonNull String number) {
                Preconditions.checkUnset(this.getParams(), "Cannot overwrite previously set phone number", "extra_phone_number", "extra_country_iso", "extra_national_number");
                if (!PhoneNumberUtils.isValid(number)) {
                    throw new IllegalStateException("Invalid phone number: " + number);
                }
                this.getParams().putString("extra_phone_number", number);
                return this;
            }

            @NonNull
            public PhoneBuilder setDefaultNumber(@NonNull String iso, @NonNull String number) {
                Preconditions.checkUnset(this.getParams(), "Cannot overwrite previously set phone number", "extra_phone_number", "extra_country_iso", "extra_national_number");
                if (!PhoneNumberUtils.isValidIso(iso)) {
                    throw new IllegalStateException("Invalid country iso: " + iso);
                }
                this.getParams().putString("extra_country_iso", iso);
                this.getParams().putString("extra_national_number", number);
                return this;
            }

            @NonNull
            public PhoneBuilder setDefaultCountryIso(@NonNull String iso) {
                Preconditions.checkUnset(this.getParams(), "Cannot overwrite previously set phone number", "extra_phone_number", "extra_country_iso", "extra_national_number");
                if (!PhoneNumberUtils.isValidIso(iso)) {
                    throw new IllegalStateException("Invalid country iso: " + iso);
                }
                this.getParams().putString("extra_country_iso", iso.toUpperCase(Locale.getDefault()));
                return this;
            }

            public PhoneBuilder setWhitelistedCountries(@NonNull List<String> whitelistedCountries) {
                if (this.getParams().containsKey("blacklisted_countries")) {
                    throw new IllegalStateException("You can either whitelist or blacklist country codes for phone authentication.");
                }
                String message = "Invalid argument: Only non-%s whitelists are valid. To specify no whitelist, do not call this method.";
                Preconditions.checkNotNull(whitelistedCountries, String.format(message, "null"), new Object[0]);
                Preconditions.checkArgument(!whitelistedCountries.isEmpty(), String.format(message, "empty"));
                this.addCountriesToBundle(whitelistedCountries, "whitelisted_countries");
                return this;
            }

            public PhoneBuilder setBlacklistedCountries(@NonNull List<String> blacklistedCountries) {
                if (this.getParams().containsKey("whitelisted_countries")) {
                    throw new IllegalStateException("You can either whitelist or blacklist country codes for phone authentication.");
                }
                String message = "Invalid argument: Only non-%s blacklists are valid. To specify no blacklist, do not call this method.";
                Preconditions.checkNotNull(blacklistedCountries, String.format(message, "null"), new Object[0]);
                Preconditions.checkArgument(!blacklistedCountries.isEmpty(), String.format(message, "empty"));
                this.addCountriesToBundle(blacklistedCountries, "blacklisted_countries");
                return this;
            }

            @Override
            public IdpConfig build() {
                this.validateInputs();
                return super.build();
            }

            private void addCountriesToBundle(List<String> CountryIsos, String CountryIsoType) {
                ArrayList<String> uppercaseCodes = new ArrayList<String>();
                for (String code : CountryIsos) {
                    uppercaseCodes.add(code.toUpperCase(Locale.getDefault()));
                }
                this.getParams().putStringArrayList(CountryIsoType, uppercaseCodes);
            }

            private void validateInputs() {
                ArrayList whitelistedCountries = this.getParams().getStringArrayList("whitelisted_countries");
                ArrayList blacklistedCountries = this.getParams().getStringArrayList("blacklisted_countries");
                if (whitelistedCountries != null && blacklistedCountries != null) {
                    throw new IllegalStateException("You can either whitelist or blacklist country codes for phone authentication.");
                }
                if (whitelistedCountries != null) {
                    this.validateInputs(whitelistedCountries, true);
                } else if (blacklistedCountries != null) {
                    this.validateInputs(blacklistedCountries, false);
                }
            }

            private void validateInputs(List<String> countries, boolean whitelisted) {
                this.validateCountryInput(countries);
                this.validateDefaultCountryInput(countries, whitelisted);
            }

            private void validateCountryInput(List<String> codes) {
                for (String code : codes) {
                    if (PhoneNumberUtils.isValidIso(code) || PhoneNumberUtils.isValid(code)) continue;
                    throw new IllegalArgumentException("Invalid input: You must provide a valid country iso (alpha-2) or code (e-164). e.g. 'us' or '+1'.");
                }
            }

            private void validateDefaultCountryInput(List<String> codes, boolean whitelisted) {
                if (!(!this.getParams().containsKey("extra_country_iso") && !this.getParams().containsKey("extra_phone_number") || this.validateDefaultCountryIso(codes, whitelisted) && this.validateDefaultPhoneIsos(codes, whitelisted))) {
                    throw new IllegalArgumentException("Invalid default country iso. Make sure it is either part of the whitelisted list or that you haven't blacklisted it.");
                }
            }

            private boolean validateDefaultCountryIso(List<String> codes, boolean whitelisted) {
                String defaultIso = this.getDefaultIso();
                return this.isValidDefaultIso(codes, defaultIso, whitelisted);
            }

            private boolean validateDefaultPhoneIsos(List<String> codes, boolean whitelisted) {
                List<String> phoneIsos = this.getPhoneIsosFromCode();
                for (String iso : phoneIsos) {
                    if (!this.isValidDefaultIso(codes, iso, whitelisted)) continue;
                    return true;
                }
                return phoneIsos.isEmpty();
            }

            private boolean isValidDefaultIso(List<String> codes, String iso, boolean whitelisted) {
                if (iso == null) {
                    return true;
                }
                boolean containsIso = this.containsCountryIso(codes, iso);
                return containsIso && whitelisted || !containsIso && !whitelisted;
            }

            private boolean containsCountryIso(List<String> codes, String iso) {
                iso = iso.toUpperCase(Locale.getDefault());
                for (String code : codes) {
                    List<String> isos;
                    if (!(PhoneNumberUtils.isValidIso(code) ? code.equals(iso) : (isos = PhoneNumberUtils.getCountryIsosFromCountryCode(code)).contains(iso))) continue;
                    return true;
                }
                return false;
            }

            private List<String> getPhoneIsosFromCode() {
                String countryCode;
                List<String> isosToAdd;
                ArrayList<String> isos = new ArrayList<String>();
                String phone = this.getParams().getString("extra_phone_number");
                if (phone != null && phone.startsWith("+") && (isosToAdd = PhoneNumberUtils.getCountryIsosFromCountryCode(countryCode = "+" + PhoneNumberUtils.getPhoneNumber(phone).getCountryCode())) != null) {
                    isos.addAll(isosToAdd);
                }
                return isos;
            }

            private String getDefaultIso() {
                return this.getParams().containsKey("extra_country_iso") ? this.getParams().getString("extra_country_iso") : null;
            }
        }

        public static final class EmailBuilder
        extends Builder {
            public EmailBuilder() {
                super("password");
            }

            @NonNull
            public EmailBuilder setAllowNewAccounts(boolean allow) {
                this.getParams().putBoolean("extra_allow_new_emails", allow);
                return this;
            }

            @NonNull
            public EmailBuilder setRequireName(boolean requireName) {
                this.getParams().putBoolean("extra_require_name", requireName);
                return this;
            }

            @NonNull
            public EmailBuilder enableEmailLinkSignIn() {
                this.setProviderId(AuthUI.EMAIL_LINK_PROVIDER);
                return this;
            }

            @NonNull
            public EmailBuilder setActionCodeSettings(ActionCodeSettings actionCodeSettings) {
                this.getParams().putParcelable("action_code_settings", (Parcelable)actionCodeSettings);
                return this;
            }

            @NonNull
            public EmailBuilder setForceSameDevice() {
                this.getParams().putBoolean("force_same_device", true);
                return this;
            }

            @Override
            public IdpConfig build() {
                if (((Builder)this).mProviderId.equals(AuthUI.EMAIL_LINK_PROVIDER)) {
                    ActionCodeSettings actionCodeSettings = (ActionCodeSettings)this.getParams().getParcelable("action_code_settings");
                    Preconditions.checkNotNull(actionCodeSettings, "ActionCodeSettings cannot be null when using email link sign in.", new Object[0]);
                    if (!actionCodeSettings.canHandleCodeInApp()) {
                        throw new IllegalStateException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
                    }
                }
                return super.build();
            }
        }

        public static class Builder {
            private final Bundle mParams = new Bundle();
            private String mProviderId;

            protected Builder(@NonNull String providerId) {
                if (!SUPPORTED_PROVIDERS.contains(providerId) && !SUPPORTED_OAUTH_PROVIDERS.contains(providerId)) {
                    throw new IllegalArgumentException("Unknown provider: " + providerId);
                }
                this.mProviderId = providerId;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
            @NonNull
            protected final Bundle getParams() {
                return this.mParams;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
            protected void setProviderId(@NonNull String providerId) {
                this.mProviderId = providerId;
            }

            @CallSuper
            @NonNull
            public IdpConfig build() {
                return new IdpConfig(this.mProviderId, this.mParams);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedProvider {
    }
}

