/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.model;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import com.firebase.ui.auth.AuthMethodPickerLayout;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.util.Preconditions;
import com.google.firebase.auth.ActionCodeSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FlowParameters
implements Parcelable {
    public static final Parcelable.Creator<FlowParameters> CREATOR = new Parcelable.Creator<FlowParameters>(){

        public FlowParameters createFromParcel(Parcel in) {
            String appName = in.readString();
            ArrayList providerInfo = in.createTypedArrayList(AuthUI.IdpConfig.CREATOR);
            AuthUI.IdpConfig defaultProvider = (AuthUI.IdpConfig)in.readParcelable(AuthUI.IdpConfig.class.getClassLoader());
            int themeId = in.readInt();
            int logoId = in.readInt();
            String termsOfServiceUrl = in.readString();
            String privacyPolicyUrl = in.readString();
            boolean enableCredentials = in.readInt() != 0;
            boolean enableHints = in.readInt() != 0;
            boolean enableAnonymousUpgrade = in.readInt() != 0;
            boolean alwaysShowProviderChoice = in.readInt() != 0;
            boolean lockOrientation = in.readInt() != 0;
            String emailLink = in.readString();
            ActionCodeSettings passwordResetSettings = (ActionCodeSettings)in.readParcelable(ActionCodeSettings.class.getClassLoader());
            AuthMethodPickerLayout customLayout = (AuthMethodPickerLayout)in.readParcelable(AuthMethodPickerLayout.class.getClassLoader());
            return new FlowParameters(appName, providerInfo, defaultProvider, themeId, logoId, termsOfServiceUrl, privacyPolicyUrl, enableCredentials, enableHints, enableAnonymousUpgrade, alwaysShowProviderChoice, lockOrientation, emailLink, passwordResetSettings, customLayout);
        }

        public FlowParameters[] newArray(int size) {
            return new FlowParameters[size];
        }
    };
    @NonNull
    public final String appName;
    @NonNull
    public final List<AuthUI.IdpConfig> providers;
    @Nullable
    public final AuthUI.IdpConfig defaultProvider;
    @StyleRes
    public final int themeId;
    @DrawableRes
    public final int logoId;
    @Nullable
    public final String termsOfServiceUrl;
    @Nullable
    public final String privacyPolicyUrl;
    @Nullable
    public String emailLink;
    @Nullable
    public final ActionCodeSettings passwordResetSettings;
    public final boolean enableCredentials;
    public final boolean enableHints;
    public final boolean enableAnonymousUpgrade;
    public final boolean alwaysShowProviderChoice;
    public final boolean lockOrientation;
    @Nullable
    public final AuthMethodPickerLayout authMethodPickerLayout;

    public FlowParameters(@NonNull String appName, @NonNull List<AuthUI.IdpConfig> providers, @Nullable AuthUI.IdpConfig defaultProvider, @StyleRes int themeId, @DrawableRes int logoId, @Nullable String termsOfServiceUrl, @Nullable String privacyPolicyUrl, boolean enableCredentials, boolean enableHints, boolean enableAnonymousUpgrade, boolean alwaysShowProviderChoice, boolean lockOrientation, @Nullable String emailLink, @Nullable ActionCodeSettings passwordResetSettings, @Nullable AuthMethodPickerLayout authMethodPickerLayout) {
        this.appName = Preconditions.checkNotNull(appName, "appName cannot be null", new Object[0]);
        this.providers = Collections.unmodifiableList(Preconditions.checkNotNull(providers, "providers cannot be null", new Object[0]));
        this.defaultProvider = defaultProvider;
        this.themeId = themeId;
        this.logoId = logoId;
        this.termsOfServiceUrl = termsOfServiceUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.enableCredentials = enableCredentials;
        this.enableHints = enableHints;
        this.enableAnonymousUpgrade = enableAnonymousUpgrade;
        this.alwaysShowProviderChoice = alwaysShowProviderChoice;
        this.lockOrientation = lockOrientation;
        this.emailLink = emailLink;
        this.passwordResetSettings = passwordResetSettings;
        this.authMethodPickerLayout = authMethodPickerLayout;
    }

    public static FlowParameters fromIntent(Intent intent) {
        return (FlowParameters)intent.getParcelableExtra("extra_flow_params");
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.appName);
        dest.writeTypedList(this.providers);
        dest.writeParcelable((Parcelable)this.defaultProvider, flags);
        dest.writeInt(this.themeId);
        dest.writeInt(this.logoId);
        dest.writeString(this.termsOfServiceUrl);
        dest.writeString(this.privacyPolicyUrl);
        dest.writeInt(this.enableCredentials ? 1 : 0);
        dest.writeInt(this.enableHints ? 1 : 0);
        dest.writeInt(this.enableAnonymousUpgrade ? 1 : 0);
        dest.writeInt(this.alwaysShowProviderChoice ? 1 : 0);
        dest.writeInt(this.lockOrientation ? 1 : 0);
        dest.writeString(this.emailLink);
        dest.writeParcelable((Parcelable)this.passwordResetSettings, flags);
        dest.writeParcelable((Parcelable)this.authMethodPickerLayout, flags);
    }

    public int describeContents() {
        return 0;
    }

    public boolean isSingleProviderFlow() {
        return this.providers.size() == 1;
    }

    public boolean isTermsOfServiceUrlProvided() {
        return !TextUtils.isEmpty((CharSequence)this.termsOfServiceUrl);
    }

    public boolean isPrivacyPolicyUrlProvided() {
        return !TextUtils.isEmpty((CharSequence)this.privacyPolicyUrl);
    }

    public boolean isAnonymousUpgradeEnabled() {
        return this.enableAnonymousUpgrade;
    }

    public boolean shouldShowProviderChoice() {
        return this.defaultProvider == null && (!this.isSingleProviderFlow() || this.alwaysShowProviderChoice);
    }

    public AuthUI.IdpConfig getDefaultOrFirstProvider() {
        return this.defaultProvider != null ? this.defaultProvider : this.providers.get(0);
    }
}

