/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.email.EmailActivity;
import com.firebase.ui.auth.viewmodel.ProviderSignInBase;
import com.google.firebase.auth.FirebaseAuth;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailSignInHandler
extends ProviderSignInBase<Void> {
    public EmailSignInHandler(Application application) {
        super(application);
    }

    @Override
    public void startSignIn(@NonNull HelperActivityBase activity) {
        activity.startActivityForResult(EmailActivity.createIntent((Context)activity, activity.getFlowParams()), 106);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode != 5 && requestCode == 106) {
            IdpResponse response = IdpResponse.fromResultIntent(data);
            if (response == null) {
                this.setResult(Resource.forFailure(new UserCancellationException()));
            } else {
                this.setResult(Resource.forSuccess(response));
            }
        }
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        this.startSignIn(activity);
    }
}

