/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.remote.GenericIdpSignInHandler;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.OAuthCredential;
import com.google.firebase.auth.OAuthProvider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GenericIdpAnonymousUpgradeLinkingHandler
extends GenericIdpSignInHandler {
    public GenericIdpAnonymousUpgradeLinkingHandler(Application application) {
        super(application);
    }

    @Override
    public void startSignIn(@NonNull HelperActivityBase activity) {
        this.setResult(Resource.forLoading());
        FlowParameters flowParameters = activity.getFlowParams();
        this.startSignIn(FirebaseAuth.getInstance((FirebaseApp)FirebaseApp.getInstance((String)flowParameters.appName)), activity, ((AuthUI.IdpConfig)this.getArguments()).getProviderId());
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        this.setResult(Resource.forLoading());
        FlowParameters flowParameters = activity.getFlowParams();
        OAuthProvider provider = this.buildOAuthProvider(providerId);
        if (flowParameters != null && AuthOperationManager.getInstance().canUpgradeAnonymous(auth, flowParameters)) {
            this.handleAnonymousUpgradeLinkingFlow(activity, provider, flowParameters);
            return;
        }
        this.handleNormalSignInFlow(auth, activity, provider);
    }

    private void handleAnonymousUpgradeLinkingFlow(HelperActivityBase activity, final OAuthProvider provider, FlowParameters flowParameters) {
        AuthOperationManager.getInstance().safeGenericIdpSignIn(activity, provider, flowParameters).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(AuthResult authResult) {
                GenericIdpAnonymousUpgradeLinkingHandler.this.handleSuccess(provider.getProviderId(), authResult.getUser(), (OAuthCredential)authResult.getCredential(), true);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                GenericIdpAnonymousUpgradeLinkingHandler.this.setResult(Resource.forFailure(e));
            }
        });
    }
}

