/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.FirebaseUiUserCollisionException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.util.FirebaseAuthError;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.ProviderSignInBase;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.OAuthCredential;
import com.google.firebase.auth.OAuthProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GenericIdpSignInHandler
extends ProviderSignInBase<AuthUI.IdpConfig> {
    public GenericIdpSignInHandler(Application application) {
        super(application);
    }

    @Override
    public void startSignIn(@NonNull HelperActivityBase activity) {
        this.setResult(Resource.forLoading());
        FlowParameters flowParameters = activity.getFlowParams();
        this.startSignIn(FirebaseAuth.getInstance((FirebaseApp)FirebaseApp.getInstance((String)flowParameters.appName)), activity, ((AuthUI.IdpConfig)this.getArguments()).getProviderId());
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        this.setResult(Resource.forLoading());
        FlowParameters flowParameters = activity.getFlowParams();
        OAuthProvider provider = this.buildOAuthProvider(providerId);
        if (flowParameters != null && AuthOperationManager.getInstance().canUpgradeAnonymous(auth, flowParameters)) {
            this.handleAnonymousUpgradeFlow(auth, activity, provider, flowParameters);
            return;
        }
        this.handleNormalSignInFlow(auth, activity, provider);
    }

    protected void handleNormalSignInFlow(FirebaseAuth auth, HelperActivityBase activity, final OAuthProvider provider) {
        auth.startActivityForSignInWithProvider((Activity)activity, (FederatedAuthProvider)provider).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(@NonNull AuthResult authResult) {
                GenericIdpSignInHandler.this.handleSuccess(provider.getProviderId(), authResult.getUser(), (OAuthCredential)authResult.getCredential(), authResult.getAdditionalUserInfo().isNewUser());
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthException) {
                    FirebaseAuthError error = FirebaseAuthError.fromException((FirebaseAuthException)e);
                    if (e instanceof FirebaseAuthUserCollisionException) {
                        FirebaseAuthUserCollisionException collisionException = (FirebaseAuthUserCollisionException)e;
                        GenericIdpSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiUserCollisionException(13, "Recoverable error.", provider.getProviderId(), collisionException.getEmail(), collisionException.getUpdatedCredential())));
                    } else if (error == FirebaseAuthError.ERROR_WEB_CONTEXT_CANCELED) {
                        GenericIdpSignInHandler.this.setResult(Resource.forFailure(new UserCancellationException()));
                    } else {
                        GenericIdpSignInHandler.this.setResult(Resource.forFailure(e));
                    }
                } else {
                    GenericIdpSignInHandler.this.setResult(Resource.forFailure(e));
                }
            }
        });
    }

    private void handleAnonymousUpgradeFlow(final FirebaseAuth auth, HelperActivityBase activity, final OAuthProvider provider, final FlowParameters flowParameters) {
        auth.getCurrentUser().startActivityForLinkWithProvider((Activity)activity, (FederatedAuthProvider)provider).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(@NonNull AuthResult authResult) {
                GenericIdpSignInHandler.this.handleSuccess(provider.getProviderId(), authResult.getUser(), (OAuthCredential)authResult.getCredential(), authResult.getAdditionalUserInfo().isNewUser());
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                if (!(e instanceof FirebaseAuthUserCollisionException)) {
                    GenericIdpSignInHandler.this.setResult(Resource.forFailure(e));
                    return;
                }
                FirebaseAuthUserCollisionException collisionException = (FirebaseAuthUserCollisionException)e;
                final AuthCredential credential = collisionException.getUpdatedCredential();
                final String email = collisionException.getEmail();
                ProviderUtils.fetchSortedProviders(auth, flowParameters, email).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<String>>(){

                    public void onSuccess(List<String> providers) {
                        if (providers.isEmpty()) {
                            String errorMessage = "Unable to complete the linkingflow - the user is using unsupported providers.";
                            GenericIdpSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(3, errorMessage)));
                            return;
                        }
                        if (providers.contains(provider.getProviderId())) {
                            GenericIdpSignInHandler.this.handleMergeFailure(credential);
                        } else {
                            GenericIdpSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiUserCollisionException(13, "Recoverable error.", provider.getProviderId(), email, credential)));
                        }
                    }
                });
            }
        });
    }

    protected OAuthProvider buildOAuthProvider(String providerId) {
        OAuthProvider.Builder providerBuilder = OAuthProvider.newBuilder((String)providerId);
        ArrayList scopes = ((AuthUI.IdpConfig)this.getArguments()).getParams().getStringArrayList("generic_oauth_scopes");
        HashMap customParams = (HashMap)((AuthUI.IdpConfig)this.getArguments()).getParams().getSerializable("generic_oauth_custom_parameters");
        if (scopes != null) {
            providerBuilder.setScopes((List)scopes);
        }
        if (customParams != null) {
            providerBuilder.addCustomParameters((Map)customParams);
        }
        return providerBuilder.build();
    }

    protected void handleSuccess(@NonNull String providerId, @NonNull FirebaseUser user, @NonNull OAuthCredential credential, boolean isNewUser, boolean setPendingCredential) {
        IdpResponse.Builder response = new IdpResponse.Builder(new User.Builder(providerId, user.getEmail()).setName(user.getDisplayName()).setPhotoUri(user.getPhotoUrl()).build()).setToken(credential.getAccessToken()).setSecret(credential.getSecret());
        if (setPendingCredential) {
            response.setPendingCredential((AuthCredential)credential);
        }
        response.setNewUser(isNewUser);
        this.setResult(Resource.forSuccess(response.build()));
    }

    protected void handleSuccess(@NonNull String providerId, @NonNull FirebaseUser user, @NonNull OAuthCredential credential, boolean isNewUser) {
        this.handleSuccess(providerId, user, credential, isNewUser, true);
    }

    protected void handleMergeFailure(@NonNull AuthCredential credential) {
        IdpResponse failureResponse = new IdpResponse.Builder().setPendingCredential(credential).build();
        this.setResult(Resource.forFailure(new FirebaseAuthAnonymousUpgradeException(5, failureResponse)));
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 117) {
            IdpResponse response = IdpResponse.fromResultIntent(data);
            if (response == null) {
                this.setResult(Resource.forFailure(new UserCancellationException()));
            } else {
                this.setResult(Resource.forSuccess(response));
            }
        }
    }

    @VisibleForTesting
    public void initializeForTesting(AuthUI.IdpConfig idpConfig) {
        this.setArguments(idpConfig);
    }
}

