/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.IntentRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.viewmodel.ProviderSignInBase;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.firebase.auth.FirebaseAuth;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GoogleSignInHandler
extends ProviderSignInBase<Params> {
    private static final String TAG = "GoogleSignInHandler";
    private AuthUI.IdpConfig mConfig;
    @Nullable
    private String mEmail;

    public GoogleSignInHandler(Application application) {
        super(application);
    }

    private static IdpResponse createIdpResponse(GoogleSignInAccount account) {
        return new IdpResponse.Builder(new User.Builder("google.com", account.getEmail()).setName(account.getDisplayName()).setPhotoUri(account.getPhotoUrl()).build()).setToken(account.getIdToken()).build();
    }

    @Override
    protected void onCreate() {
        Params params = (Params)this.getArguments();
        this.mConfig = params.config;
        this.mEmail = params.email;
    }

    @Override
    public void startSignIn(@NonNull HelperActivityBase activity) {
        this.start();
    }

    private void start() {
        this.setResult(Resource.forLoading());
        this.setResult(Resource.forFailure(new IntentRequiredException(GoogleSignIn.getClient((Context)this.getApplication(), (GoogleSignInOptions)this.getSignInOptions()).getSignInIntent(), 110)));
    }

    private GoogleSignInOptions getSignInOptions() {
        GoogleSignInOptions.Builder builder = new GoogleSignInOptions.Builder((GoogleSignInOptions)this.mConfig.getParams().getParcelable("extra_google_sign_in_options"));
        if (!TextUtils.isEmpty((CharSequence)this.mEmail)) {
            builder.setAccountName(this.mEmail);
        }
        return builder.build();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != 110) {
            return;
        }
        try {
            GoogleSignInAccount account = (GoogleSignInAccount)GoogleSignIn.getSignedInAccountFromIntent((Intent)data).getResult(ApiException.class);
            this.setResult(Resource.forSuccess(GoogleSignInHandler.createIdpResponse(account)));
        }
        catch (ApiException e) {
            if (e.getStatusCode() == 5) {
                this.mEmail = null;
                this.start();
            }
            if (e.getStatusCode() == 12502) {
                this.start();
            }
            if (e.getStatusCode() == 12501) {
                this.setResult(Resource.forFailure(new UserCancellationException()));
            }
            if (e.getStatusCode() == 10) {
                Log.w((String)TAG, (String)"Developer error: this application is misconfigured. Check your SHA1 and package name in the Firebase console.");
            }
            this.setResult(Resource.forFailure(new FirebaseUiException(4, "Code: " + e.getStatusCode() + ", message: " + e.getMessage())));
        }
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        this.startSignIn(activity);
    }

    public static final class Params {
        private final AuthUI.IdpConfig config;
        @Nullable
        private final String email;

        public Params(AuthUI.IdpConfig config) {
            this(config, null);
        }

        public Params(AuthUI.IdpConfig config, @Nullable String email) {
            this.config = config;
            this.email = email;
        }
    }
}

