/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.IntentRequiredException;
import com.firebase.ui.auth.data.model.PendingIntentRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.ui.email.EmailActivity;
import com.firebase.ui.auth.ui.email.EmailLinkCatcherActivity;
import com.firebase.ui.auth.ui.idp.AuthMethodPickerActivity;
import com.firebase.ui.auth.ui.idp.SingleSignInActivity;
import com.firebase.ui.auth.ui.phone.PhoneActivity;
import com.firebase.ui.auth.util.GoogleApiUtils;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.CredentialRequest;
import com.google.android.gms.auth.api.credentials.CredentialRequestResponse;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import java.util.ArrayList;
import java.util.List;

public class SignInKickstarter
extends SignInViewModelBase {
    public SignInKickstarter(Application application) {
        super(application);
    }

    public void start() {
        boolean willRequestCredentials;
        if (!TextUtils.isEmpty((CharSequence)((FlowParameters)this.getArguments()).emailLink)) {
            this.setResult(Resource.forFailure(new IntentRequiredException(EmailLinkCatcherActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments()), 106)));
            return;
        }
        Task pendingResultTask = this.getAuth().getPendingAuthResult();
        if (pendingResultTask != null) {
            pendingResultTask.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

                public void onSuccess(AuthResult authResult) {
                    IdpResponse response = new IdpResponse.Builder(new User.Builder(authResult.getCredential().getProvider(), authResult.getUser().getEmail()).build()).build();
                    SignInKickstarter.this.handleSuccess(response, authResult);
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    SignInKickstarter.this.setResult(Resource.forFailure(e));
                }
            });
            return;
        }
        boolean supportPasswords = ProviderUtils.getConfigFromIdps(((FlowParameters)this.getArguments()).providers, "password") != null;
        List<String> accountTypes = this.getCredentialAccountTypes();
        boolean bl = willRequestCredentials = supportPasswords || accountTypes.size() > 0;
        if (((FlowParameters)this.getArguments()).enableCredentials && willRequestCredentials) {
            this.setResult(Resource.forLoading());
            GoogleApiUtils.getCredentialsClient((Context)this.getApplication()).request(new CredentialRequest.Builder().setPasswordLoginSupported(supportPasswords).setAccountTypes(accountTypes.toArray(new String[accountTypes.size()])).build()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<CredentialRequestResponse>(){

                public void onComplete(@NonNull Task<CredentialRequestResponse> task) {
                    try {
                        SignInKickstarter.this.handleCredential(((CredentialRequestResponse)task.getResult(ApiException.class)).getCredential());
                    }
                    catch (ResolvableApiException e) {
                        if (e.getStatusCode() == 6) {
                            SignInKickstarter.this.setResult(Resource.forFailure(new PendingIntentRequiredException(e.getResolution(), 101)));
                        } else {
                            SignInKickstarter.this.startAuthMethodChoice();
                        }
                    }
                    catch (ApiException e) {
                        SignInKickstarter.this.startAuthMethodChoice();
                    }
                }
            });
        } else {
            this.startAuthMethodChoice();
        }
    }

    private void startAuthMethodChoice() {
        if (!((FlowParameters)this.getArguments()).shouldShowProviderChoice()) {
            String firstProvider;
            AuthUI.IdpConfig firstIdpConfig = ((FlowParameters)this.getArguments()).getDefaultOrFirstProvider();
            switch (firstProvider = firstIdpConfig.getProviderId()) {
                case "emailLink": 
                case "password": {
                    this.setResult(Resource.forFailure(new IntentRequiredException(EmailActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments()), 106)));
                    break;
                }
                case "phone": {
                    this.setResult(Resource.forFailure(new IntentRequiredException(PhoneActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), firstIdpConfig.getParams()), 107)));
                    break;
                }
                default: {
                    this.redirectSignIn(firstProvider, null);
                    break;
                }
            }
        } else {
            this.setResult(Resource.forFailure(new IntentRequiredException(AuthMethodPickerActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments()), 105)));
        }
    }

    private void redirectSignIn(String provider, String id2) {
        switch (provider) {
            case "password": {
                this.setResult(Resource.forFailure(new IntentRequiredException(EmailActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), id2), 106)));
                break;
            }
            case "phone": {
                Bundle args = new Bundle();
                args.putString("extra_phone_number", id2);
                this.setResult(Resource.forFailure(new IntentRequiredException(PhoneActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), args), 107)));
                break;
            }
            default: {
                this.setResult(Resource.forFailure(new IntentRequiredException(SingleSignInActivity.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), new User.Builder(provider, id2).build()), 109)));
            }
        }
    }

    private List<String> getCredentialAccountTypes() {
        ArrayList<String> accounts = new ArrayList<String>();
        for (AuthUI.IdpConfig idpConfig : ((FlowParameters)this.getArguments()).providers) {
            String providerId = idpConfig.getProviderId();
            if (!providerId.equals("google.com")) continue;
            accounts.add(ProviderUtils.providerIdToAccountType(providerId));
        }
        return accounts;
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        switch (requestCode) {
            case 101: {
                if (resultCode == -1) {
                    this.handleCredential((Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential"));
                    break;
                }
                this.startAuthMethodChoice();
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 109: {
                if (resultCode == 113 || resultCode == 114) {
                    this.startAuthMethodChoice();
                    return;
                }
                IdpResponse response = IdpResponse.fromResultIntent(data);
                if (response == null) {
                    this.setResult(Resource.forFailure(new UserCancellationException()));
                    break;
                }
                if (response.isSuccessful()) {
                    this.setResult(Resource.forSuccess(response));
                    break;
                }
                if (response.getError().getErrorCode() == 5) {
                    this.handleMergeFailure(response);
                    break;
                }
                this.setResult(Resource.forFailure(response.getError()));
            }
        }
    }

    private void handleCredential(final Credential credential) {
        String id2 = credential.getId();
        String password = credential.getPassword();
        if (TextUtils.isEmpty((CharSequence)password)) {
            String identity = credential.getAccountType();
            if (identity == null) {
                this.startAuthMethodChoice();
            } else {
                this.redirectSignIn(ProviderUtils.accountTypeToProviderId(credential.getAccountType()), id2);
            }
        } else {
            final IdpResponse response = new IdpResponse.Builder(new User.Builder("password", id2).build()).build();
            this.setResult(Resource.forLoading());
            this.getAuth().signInWithEmailAndPassword(id2, password).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

                public void onSuccess(AuthResult result) {
                    SignInKickstarter.this.handleSuccess(response, result);
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    if (e instanceof FirebaseAuthInvalidUserException || e instanceof FirebaseAuthInvalidCredentialsException) {
                        GoogleApiUtils.getCredentialsClient((Context)SignInKickstarter.this.getApplication()).delete(credential);
                    }
                    SignInKickstarter.this.startAuthMethodChoice();
                }
            });
        }
    }
}

